/*******************************************************************
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.hana.search;

import static java.util.stream.Collectors.joining;

import java.util.Collection;

import com.sap.cds.ql.cqn.CqnElementRef;

public class SearchResolverUtils {

	private SearchResolverUtils() {

	}

	public static String refNames(Collection<CqnElementRef> refs) {
		return refs.stream().map(ref -> ref.displayName()).collect(joining(","));
	}

}
