/************************************************************************
 * © 2021-2023 SAP SE or an SAP affiliate company. All rights reserved. *
 ************************************************************************/
package com.sap.cds.jdbc.sqlite;

import java.util.Locale;
import java.util.TimeZone;

import com.sap.cds.CdsDataStoreConnector.Capabilities;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.generic.LocaleNameTableNameResolver;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.jdbc.spi.ValueBinder;

public final class SqliteDbContext extends GenericDbContext {

	public SqliteDbContext(DataStoreConfiguration dataStoreConfiguration) {
		super(dataStoreConfiguration);
	}

	@Override
	public FunctionMapper getFunctionMapper() {
		return new SqliteFunctionMapper();
	}

	@Override
	public StatementResolver getStatementResolver() {
		return new SqliteStatementResolver();
	}

	@Override
	public ExceptionAnalyzer getExceptionAnalyzer() {
		return new SqliteExceptionAnalyzer();
	}

	@Override
	public Capabilities getCapabilities() {
		return new Capabilities() {
			@Override
			public boolean supportsLock() {
				return false;
			}
		};
	}

	@Override
	public PredicateMapper getPredicateMapper() {
		return p -> p;
	}

	@Override
	public SessionVariableSetter getSessionVariableSetter() {
		return new SqliteSessionVariableSetter();
	}

	@Override
	public TableNameResolver createTableNameResolver(Locale locale) {
		if (config.useLocaleSpecificView()) {
			return new LocaleNameTableNameResolver(this::getSqlMapping, config, locale);
		}

		return super.createTableNameResolver(locale);
	}

	@Override
	public ValueBinder getBinder(TimeZone timeZone) {
		return new SqliteBinder(timeZone);
	}

}
