/*******************************************************************
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved. *
 *******************************************************************/
package com.sap.cds.jdbc.sqlite;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;

import org.sqlite.Function;
import org.sqlite.SQLiteConnection;

import com.sap.cds.jdbc.spi.SessionVariableSetter;

public class SqliteSessionVariableSetter implements SessionVariableSetter {

	@Override
	public void set(Connection conn, Map<String, Object> contextVariables) throws SQLException {
		SQLiteConnection sqliteCon = conn.unwrap(SQLiteConnection.class);
		Function.create(sqliteCon, "session_context", new SessionContextFunction(contextVariables));
	}

	private static class SessionContextFunction extends Function {

		private Map<String, Object> contextVariables;

		public SessionContextFunction(Map<String, Object> contextVariables) {
			this.contextVariables = contextVariables;
		}

		@Override
		protected void xFunc() throws SQLException {
			String sqliteKey = value_text(0);
			String key = switch (sqliteKey) {
				case "$user.id" -> APPLICATIONUSER;
				case "$user.locale" -> LOCALE;
				case "$valid.from", "$at.from" -> VALID_FROM;
				case "$valid.to", "$at.to" -> VALID_TO;
				default -> null;
			};
			Object val = contextVariables.get(key);
			if (val != null) {
				result(val.toString());
			} else {
				result();
			}
		}

	}

}
