/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.search;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.DraftUtils;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.jdbc.hana.search.HanaSearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.impl.SelectBuilder;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsSearchUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HanaSearchResolverUsingContains
extends HanaSearchResolver {
    private static final Logger logger = LoggerFactory.getLogger(HanaSearchResolverUsingContains.class);

    public HanaSearchResolverUsingContains(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        super(config, cdsModel, locale);
    }

    @Override
    protected CqnPredicate searchToHana(CqnListValue refs, CqnPredicate expression) {
        String searchString = HanaSearchResolverUsingContains.toSearchString((CqnPredicate)CqnStatementUtils.simplifyPredicate((CqnPredicate)expression));
        return CQL.booleanFunc((String)"CONTAINS", List.of(refs, CQL.val((Object)searchString)));
    }

    @Override
    protected boolean needsPushToSubquery(CdsElement element) {
        return HanaSearchResolverUsingContains.isDeclaredByActiveEntity(element);
    }

    private static boolean isDeclaredByActiveEntity(CdsElement element) {
        CdsStructuredType declaringType = (CdsStructuredType)element.getDeclaringType();
        if (HanaSearchResolverUsingContains.isActiveEntity(declaringType)) {
            logger.debug("Fallback to search with LIKE. Entity {} is draft-enabled. This causes a subquery in SQL, which prevents the usage of CONTAINS.", (Object)declaringType);
            return true;
        }
        return false;
    }

    private static boolean isActiveEntity(CdsStructuredType targetType) {
        return DraftUtils.isDraftEnabled(targetType) && !DraftUtils.isDraftView(targetType);
    }

    public void pushDownSearchToSubquery(CqnSelect select, CqnSelect subquery) {
        CqnPredicate merged = (CqnPredicate)Conjunction.and((Optional)subquery.search(), (Optional)select.search()).orElse(CqnBoolLiteral.TRUE);
        CqnSource source = subquery.from();
        if (source.isRef()) {
            CdsEntity targetEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)subquery.ref());
            List resolved = CqnStatementUtils.resolveStar((List)subquery.items(), (Collection)subquery.excluding(), (CdsStructuredType)targetEntity, (boolean)false);
            Set exposed = resolved.stream().flatMap(CqnSelectListItem::ofRef).map(CqnReference::lastSegment).collect(Collectors.toSet());
            Set intersection = CdsSearchUtils.getSearchableElements((CqnSelect)subquery, (CdsStructuredType)targetEntity).stream().map(CqnReference::lastSegment).filter(exposed::contains).collect(Collectors.toSet());
            ((SelectBuilder)subquery.asSelect()).search(t -> (Predicate)merged, intersection);
        } else {
            ((SelectBuilder)subquery.asSelect()).search(merged);
        }
        ((SelectBuilder)select).search((CqnPredicate)null);
    }

    @Override
    protected void handleLargeStringElement(Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> containsMainQuery, CdsStructuredType targetType, CqnElementRef ref, CdsElement element) {
        logger.debug("Searching large string element {} in entity {} using LIKE since CONTAINS is not supported for (N)CLOB columns on SAP HANA", (Object)ref, (Object)targetType);
        likeMainQuery.add(ref);
    }

    @Override
    protected void handleLocalizedElement(CdsStructuredType targetType, Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> containsSubquery, Set<CqnElementRef> containsMainQuery, boolean languageGiven, CqnElementRef ref, CdsElement element) {
        if (languageGiven) {
            if (HanaSearchResolverUsingContains.isReachableViaLocalizedAssoc(element)) {
                containsSubquery.add(ref);
                containsSubquery.add(this.localizedRef(ref));
            } else {
                likeMainQuery.add(ref);
            }
        } else {
            containsMainQuery.add(ref);
        }
    }

    @Override
    protected void handleRegularElement(CdsStructuredType targetType, Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> containsMainQuery, CqnElementRef ref, CdsElement element) {
        CdsEntity e;
        if (targetType instanceof CdsEntity && this.isComputed(e = (CdsEntity)targetType, ref)) {
            likeMainQuery.add(ref);
        } else {
            containsMainQuery.add(ref);
        }
    }

    private boolean isComputed(CdsEntity targetEntity, CqnElementRef ref) {
        if (Boolean.TRUE.equals(targetEntity.getAnnotationValue("@cds.persistence.exists", (Object)false))) {
            logger.debug("The searchable ref {} is treated as 'computed' as the targetEntity {} is annotated with {} and we cannot analyze computed refs.", new Object[]{ref, targetEntity, "@cds.persistence.exists"});
            return true;
        }
        if (!targetEntity.isView()) {
            return targetEntity.findElement(ref.path()).map(CdsElementDefinition::isCalculated).orElse(false);
        }
        Optional targetQuery = targetEntity.query();
        if (!targetQuery.isPresent()) {
            logger.debug("The searchable ref {} is treated as 'computed' as the targetEntity {} is a view with an unsupported query.", (Object)ref, (Object)targetEntity);
            return true;
        }
        CqnSelect query = (CqnSelect)targetQuery.get();
        CqnSource source = query.from();
        if (!source.isRef()) {
            logger.debug("The searchable ref {} is treated as 'computed' as the query {} of the targetEntity {} selects from a source which is not a ref {}.", new Object[]{ref, query, targetEntity, source});
            return true;
        }
        String startSegName = ref.firstSegment();
        Optional<CqnSelectListValue> match = query.items().stream().flatMap(CqnSelectListItem::ofValue).filter(slv -> slv.displayName().equals(startSegName)).findFirst();
        if (match.isPresent()) {
            CqnSelectListValue slv2 = match.get();
            if (!slv2.isRef()) {
                return true;
            }
            ref = HanaSearchResolverUsingContains.concatRefs(slv2.asRef(), ref);
        }
        CqnStructuredTypeRef typeRef = query.ref();
        CdsEntity sourceEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)typeRef);
        return this.isComputed(sourceEntity, ref);
    }

    private static CqnElementRef concatRefs(CqnElementRef prefix, CqnElementRef suffix) {
        int tail = suffix.size();
        ArrayList segs = new ArrayList(prefix.size() + tail - 1);
        segs.addAll(prefix.segments());
        segs.addAll(suffix.segments().subList(1, tail));
        return ElementRefImpl.elementRef(segs, null, null);
    }

    @Override
    protected String defaultSearchMode() {
        return "localized-association";
    }
}

