/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.sap.cds.CdsData;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsList;
import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Cascader;
import com.sap.cds.impl.EntityCascader;
import com.sap.cds.impl.RowImpl;
import com.sap.cds.impl.parser.token.RefSegmentBuilder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OccUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeepUpdateSplitter {
    private static final Logger logger = LoggerFactory.getLogger(DeepUpdateSplitter.class);
    private final CdsDataStore dataStore;
    private final SessionContext session;
    private CdsEntity entity;
    private EntityCascader.EntityOperations operations;
    private boolean deepUpsert;
    private boolean occEnabled;

    public DeepUpdateSplitter(CdsDataStore dataStore) {
        this.dataStore = dataStore;
        this.session = dataStore.getSessionContext();
    }

    public EntityCascader.EntityOperations computeOperations(CdsEntity targetEntity, CqnUpdate update, Map<String, Object> targetKeys) {
        StructuredType<?> path = DeepUpdateSplitter.targetRef(update);
        return this.computeOps(EntityCascader.EntityOperation.Operation.UPDATE, path, targetEntity, targetKeys, update.entries());
    }

    public EntityCascader.EntityOperations computeOperations(CdsEntity targetEntity, CqnUpsert upsert, Map<String, Object> targetKeys) {
        this.deepUpsert = true;
        StructuredType path = CQL.to((List)RefSegmentBuilder.copy((List)upsert.ref().segments()));
        return this.computeOps(EntityCascader.EntityOperation.Operation.UPSERT, path, targetEntity, targetKeys, upsert.entries());
    }

    private EntityCascader.EntityOperations computeOps(EntityCascader.EntityOperation.Operation op, StructuredType<?> path, CdsEntity targetEntity, Map<String, Object> targetKeys, List<Map<String, Object>> entries) {
        this.entity = targetEntity;
        this.occEnabled = OccUtils.occEnabled((CdsEntity)this.entity);
        this.operations = new EntityCascader.EntityOperations();
        this.operations.entries(entries);
        List<Map<String, Object>> updateEntries = this.determineEntries(targetKeys, path);
        for (Map<String, Object> entry : updateEntries) {
            EntityCascader.EntityKeys entityId = EntityCascader.EntityKeys.keys(this.entity, entry);
            this.operations.add(EntityCascader.EntityOperation.root(entityId, op, this.session).update(entry, Collections.emptyMap()));
        }
        if (!updateEntries.isEmpty()) {
            this.entity.associations().forEach(assoc -> this.cascade(path, (CdsElement)assoc, updateEntries));
        }
        return this.operations;
    }

    private List<Map<String, Object>> determineEntries(Map<String, Object> targetKeys, StructuredType<?> path) {
        Set<String> targetKeyElements;
        Set missingKeys;
        Set keyElements = CdsModelUtils.concreteKeyNames((CdsStructuredType)this.entity);
        if (!CqnStatementUtils.hasInfixFilter((CqnReference)path.asRef())) {
            this.operations.entries().forEach(e -> DeepUpdateSplitter.addKeyValues(this.entity, targetKeys, e));
            if (this.entriesContainValuesFor(keyElements)) {
                return this.operations.entries();
            }
        }
        if (!this.entriesContainValuesFor(missingKeys = Sets.filter((Set)keyElements, arg_0 -> DeepUpdateSplitter.lambda$determineEntries$2(targetKeyElements = targetKeys.keySet(), arg_0)))) {
            return this.selectKeyValues(path, missingKeys);
        }
        return this.evaluateFilter(path, targetKeys, keyElements);
    }

    private boolean entriesContainValuesFor(Set<String> elements) {
        return this.operations.entries().stream().allMatch(e -> e.keySet().containsAll(elements));
    }

    private List<Map<String, Object>> selectKeyValues(StructuredType<?> path, Set<String> missingKeys) {
        if (this.operations.entries().size() == 1) {
            logger.warn("Update data is missing key values of entity {}. Executing query to determine key values.", (Object)this.entity.getQualifiedName());
            Select select = Select.from(path).columns(missingKeys.stream().map(CQL::get));
            if (this.occEnabled) {
                select.lock();
            }
            Result result = this.dataStore.execute((CqnSelect)select, new Object[0]);
            Map<String, Object> singleEntry = this.operations.entries().get(0);
            ArrayList<Map<String, Object>> updateEntries = new ArrayList<Map<String, Object>>();
            if (result.rowCount() == 1L) {
                Row keyValues = result.single();
                singleEntry.putAll((Map<String, Object>)keyValues);
                updateEntries.add(singleEntry);
            } else if (result.rowCount() > 1L) {
                result.forEach(row -> row.putAll((Map)DataUtils.copyMap((Map)singleEntry)));
                updateEntries.addAll(result.list());
            }
            return updateEntries;
        }
        throw new CdsDataException("Update data is missing key values " + missingKeys + " of entity " + this.entity);
    }

    private List<Map<String, Object>> evaluateFilter(StructuredType<?> path, Map<String, Object> targetKeys, Set<String> keyElements) {
        logger.debug("Executing query to evaluate update filter condition {}", path);
        if (!targetKeys.isEmpty()) {
            this.operations.entries().forEach(e -> DeepUpdateSplitter.addKeyValues(this.entity, targetKeys, e));
        }
        ArrayList<Map<String, Object>> updateEntries = new ArrayList<Map<String, Object>>();
        Map<String, Row> entityKeys = this.selectKeysMatchingPathFilter(path, keyElements, this.operations.entries());
        Map updateData = this.operations.entries().stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.index(row, keyElements), Function.identity()));
        entityKeys.forEach((hash, key) -> updateEntries.add((Map)updateData.get(hash)));
        logger.debug("Update filter condition fulfilled by {} entities", (Object)entityKeys.size());
        return updateEntries;
    }

    private static void addKeyValues(CdsEntity entity, Map<String, Object> keyValues, Map<String, Object> target) {
        keyValues.forEach((key, valInRef) -> {
            Object valInData = target.put((String)key, valInRef);
            if (valInData != null && !valInData.equals(valInRef)) {
                throw new CdsDataException("Values for key element '" + key + "' in update data do not match values in update ref or where clause");
            }
        });
        target.putAll(Maps.filterValues((Map)DataUtils.keyValues((CdsEntity)entity, target), v -> !Objects.isNull(v)));
    }

    private static StructuredType<?> targetRef(CqnUpdate update) {
        if (!CqnStatementUtils.containsPathExpression((Optional)update.where())) {
            return CqnStatementUtils.targetRef((CqnUpdate)update);
        }
        throw new UnsupportedOperationException("Deep updates with path in where clause are not supported");
    }

    private Map<String, Row> selectKeysMatchingPathFilter(StructuredType<?> path, Set<String> keys, Iterable<Map<String, Object>> keyValueSets) {
        Select select = Select.from(path).columns(keys.stream().map(CQL::get)).byParams(keys);
        if (this.occEnabled) {
            select.lock();
        }
        Iterable params = OccUtils.addOldVersionParam((CdsEntity)this.entity, keyValueSets);
        Result entries = this.dataStore.execute((CqnSelect)select, params);
        return entries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.index((Map<String, Object>)row, keys), Function.identity()));
    }

    private void cascade(StructuredType<?> path, CdsElement assoc, List<Map<String, Object>> entries) {
        Iterable updateEntries = Iterables.filter(entries, e -> e.containsKey(assoc.getName()));
        if (!Iterables.isEmpty((Iterable)updateEntries)) {
            CdsEntity targetEntity = ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).getTarget();
            if (CdsModelUtils.isSingleValued((CdsType)assoc.getType())) {
                this.toOne(path, assoc, targetEntity, updateEntries);
            } else {
                this.toMany(path, assoc, targetEntity, updateEntries);
            }
        }
    }

    private void toOne(StructuredType<?> path, CdsElement assoc, CdsEntity child, Iterable<Map<String, Object>> parentEntries) {
        CdsEntity parent = (CdsEntity)assoc.getDeclaringType();
        boolean forward = !CdsModelUtils.isReverseAssociation((CdsElement)assoc);
        boolean composition = ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).isComposition();
        Set parentKeys = CdsModelUtils.concreteKeyNames((CdsStructuredType)parent);
        Map<String, Row> expandedParentEntries = this.deepUpsert ? Collections.emptyMap() : this.selectPathExpandToOneTargetKeys(path, assoc, forward, parentKeys, parentEntries);
        ArrayList<Map<String, Object>> childEntries = new ArrayList<Map<String, Object>>(Iterables.size(parentEntries));
        for (Map<String, Object> parentEntry : parentEntries) {
            Map childEntry = (Map)DeepUpdateSplitter.getDataFor(assoc, parentEntry);
            if (this.deepUpsert) {
                this.upsertToOne(parent, child, assoc, forward, composition, parentEntry, childEntry, childEntries);
                continue;
            }
            this.updateToOne(parent, child, assoc, forward, composition, parentKeys, expandedParentEntries, parentEntry, childEntry, childEntries);
        }
        child.associations().forEach(a -> this.cascade((StructuredType<?>)path.to(assoc.getName()), (CdsElement)a, (List<Map<String, Object>>)childEntries));
    }

    private void upsertToOne(CdsEntity parent, CdsEntity child, CdsElement assoc, boolean forward, boolean composition, Map<String, Object> parentEntry, Map<String, Object> childEntry, List<Map<String, Object>> childEntries) {
        if (childEntry == null) {
            this.remove(assoc, forward, parent, Collections.singletonList(parentEntry), assoc.getName());
        } else if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)assoc) || CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)assoc)) {
            childEntries.add(childEntry);
            this.operations.add(this.xsert(parentEntry, assoc, forward, child, childEntry, false));
        } else if (forward && !composition) {
            DeepUpdateSplitter.removeNonFkValues(assoc, childEntry);
        }
    }

    private void updateToOne(CdsEntity parentEntity, CdsEntity targetEntity, CdsElement assoc, boolean forward, boolean composition, Set<String> parentKeys, Map<String, Row> expandedParentEntries, Map<String, Object> parentUpdateEntry, Map<String, Object> targetUpdateEntry, List<Map<String, Object>> targetUpdateEntries) {
        Row parentEntry = expandedParentEntries.getOrDefault(DeepUpdateSplitter.index(parentUpdateEntry, parentKeys), RowImpl.row(Collections.emptyMap()));
        Map targetEntry = (Map)DeepUpdateSplitter.getDataFor(assoc, (Map<String, Object>)parentEntry);
        if (targetEntry != null && !targetEntry.isEmpty()) {
            if (targetUpdateEntry == null) {
                this.remove(assoc, forward, targetEntity, Collections.singletonList(targetEntry), null);
            } else if (DeepUpdateSplitter.targetChange(assoc, forward && !composition, targetEntity, targetEntry, targetUpdateEntry)) {
                if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)assoc) || CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)assoc)) {
                    this.operations.add(this.xsert(parentUpdateEntry, assoc, forward, targetEntity, targetUpdateEntry, composition));
                    targetUpdateEntries.add(targetUpdateEntry);
                } else {
                    DeepUpdateSplitter.removeNonFkValues(assoc, targetUpdateEntry);
                }
                if (composition) {
                    this.delete(targetEntity, targetEntry, null);
                }
            } else if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)assoc)) {
                this.operations.add(this.update(targetEntity, targetEntry, targetUpdateEntry, Collections.emptyMap()));
                targetUpdateEntries.add(targetUpdateEntry);
            }
        } else if (targetUpdateEntry != null) {
            if (forward && !composition && !CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)assoc)) {
                DeepUpdateSplitter.removeNonFkValues(assoc, targetUpdateEntry);
            } else {
                boolean generatedKey = DataUtils.generateUuidKeys((CdsStructuredType)targetEntity, targetUpdateEntry);
                if (forward && generatedKey) {
                    EntityCascader.EntityKeys parentKeyValues = EntityCascader.EntityKeys.keys(parentEntity, parentUpdateEntry);
                    Map<String, Object> targetRefValues = this.fkValues(assoc, !forward, targetUpdateEntry);
                    this.operations.add(this.update(parentEntity, (Map<String, Object>)((Object)parentKeyValues), new HashMap<String, Object>(), targetRefValues));
                }
                boolean insertOnly = composition || generatedKey;
                this.operations.add(this.xsert(parentUpdateEntry, assoc, forward, targetEntity, targetUpdateEntry, insertOnly));
                targetUpdateEntries.add(targetUpdateEntry);
            }
        }
    }

    private static boolean targetChange(CdsElement assoc, boolean forward, CdsEntity targetEntity, Map<String, Object> oldEntry, Map<String, Object> newEntry) {
        Set<String> refElements = forward ? DeepUpdateSplitter.refElements(assoc, forward) : CdsModelUtils.concreteKeyNames((CdsStructuredType)targetEntity);
        return refElements.stream().anyMatch(k -> {
            Object newVal = newEntry.get(k);
            return newVal != null && !newVal.equals(oldEntry.get(k));
        });
    }

    private static void removeNonFkValues(CdsElement assoc, Map<String, Object> data) {
        Set<String> assocKeys = DeepUpdateSplitter.refElements(assoc, true);
        data.keySet().retainAll(assocKeys);
    }

    private Map<String, Row> selectPathExpandToOneTargetKeys(StructuredType<?> path, CdsElement assoc, boolean forwardMapped, Set<String> parentKeys, Iterable<Map<String, Object>> keyValueSets) {
        logger.debug("Executing query to determine target entity of {}", (Object)assoc.getQualifiedName());
        List slis = parentKeys.stream().map(CQL::get).collect(Collectors.toList());
        Set<String> refElements = DeepUpdateSplitter.refElements(assoc, forwardMapped);
        CdsModelUtils.targetKeys((CdsElement)assoc).forEach(refElements::add);
        slis.add(CQL.to((String)assoc.getName()).expand(refElements.toArray(new String[refElements.size()])));
        Select select = Select.from(path).columns(slis).byParams(parentKeys);
        Iterable params = OccUtils.addOldVersionParam((CdsEntity)this.entity, keyValueSets);
        Result targetEntries = this.dataStore.execute((CqnSelect)select, params);
        return targetEntries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.index((Map<String, Object>)row, parentKeys), Function.identity()));
    }

    private Map<String, Object> fkValues(CdsElement assoc, boolean reverseMapped, Map<String, Object> data) {
        return new OnConditionAnalyzer(assoc, reverseMapped, this.session).getFkValues(data);
    }

    private void toMany(StructuredType<?> path, CdsElement assoc, CdsEntity targetEntity, Iterable<Map<String, Object>> parentEntries) {
        boolean composition = ((CdsAssociationType)assoc.getType().as(CdsAssociationType.class)).isComposition();
        Set parentKeys = CdsModelUtils.concreteKeyNames((CdsStructuredType)((CdsStructuredType)assoc.getDeclaringType()));
        Set targetKeys = CdsModelUtils.targetKeys((CdsElement)assoc);
        Map<String, Row> fullSetTargetEntries = this.selectTargetEntries(assoc, parentKeys, targetKeys, parentEntries);
        ArrayList<HashMap<String, Object>> updateEntries = new ArrayList<HashMap<String, Object>>(Iterables.size(parentEntries));
        for (Map<String, Object> parentEntry : parentEntries) {
            List targetUpdateEntries = (List)DeepUpdateSplitter.getDataFor(assoc, parentEntry);
            if (targetUpdateEntries == null) {
                throw new CdsDataException("Value for to-many association '" + assoc.getDeclaringType() + "." + assoc + "' must not be null.");
            }
            Map parentRefValues = new OnConditionAnalyzer(assoc, true, this.session).getFkValues(parentEntry);
            if (parentRefValues.containsValue(null)) {
                throw new CdsDataException("Values of ref elements " + parentRefValues.keySet() + " for mapping " + targetEntity + " to " + assoc.getDeclaringType() + " cannot be determined from update data.");
            }
            boolean delta = DeepUpdateSplitter.isDelta(targetUpdateEntries);
            for (Map updateEntry : targetUpdateEntries) {
                EntityCascader.EntityOperation operation;
                HashMap<String, Object> updateEntryWithFks = new HashMap<String, Object>(updateEntry);
                updateEntryWithFks.putAll(parentRefValues);
                if (delta) {
                    if (DeepUpdateSplitter.isRemove(updateEntry)) {
                        this.remove(assoc, false, targetEntity, Collections.singletonList(updateEntryWithFks), null);
                        continue;
                    }
                    operation = this.xsert(assoc, targetEntity, updateEntry, parentRefValues, false);
                } else {
                    boolean targetPresent;
                    boolean bl = targetPresent = fullSetTargetEntries.remove(DeepUpdateSplitter.index(updateEntryWithFks, targetKeys)) != null;
                    if (this.deepUpsert) {
                        operation = this.xsert(assoc, targetEntity, updateEntry, parentRefValues, false);
                    } else {
                        boolean generatedKey;
                        boolean bl2 = generatedKey = !targetPresent && DataUtils.generateUuidKeys((CdsStructuredType)targetEntity, (Map)updateEntry);
                        if (generatedKey) {
                            updateEntryWithFks.putAll(updateEntry);
                        }
                        EntityCascader.EntityKeys targetId = EntityCascader.EntityKeys.keys(targetEntity, updateEntryWithFks);
                        operation = generatedKey ? EntityCascader.EntityOperation.insert(targetId, updateEntry, parentRefValues, this.session) : (targetPresent ? EntityCascader.EntityOperation.nop(targetId, null, this.session).update(updateEntry, Collections.emptyMap()) : this.xsert(assoc, targetEntity, updateEntry, parentRefValues, composition));
                    }
                }
                DeepUpdateSplitter.assertCascading(operation, assoc);
                this.operations.add(operation);
                updateEntries.add(updateEntryWithFks);
            }
        }
        this.remove(assoc, false, targetEntity, fullSetTargetEntries.values(), null);
        targetEntity.associations().forEach(a -> this.cascade((StructuredType<?>)path.to(assoc.getName()), (CdsElement)a, (List<Map<String, Object>>)updateEntries));
    }

    private static boolean isDelta(List<Map<String, Object>> entries) {
        if (entries instanceof CdsList) {
            return ((CdsList)entries).isDelta();
        }
        return false;
    }

    private static boolean isRemove(Map<String, Object> entry) {
        if (entry instanceof CdsData) {
            return ((CdsData)entry).isForRemoval();
        }
        return false;
    }

    private Map<String, Row> selectTargetEntries(CdsElement assoc, Set<String> parentKeys, Set<String> targetKeys, Iterable<Map<String, Object>> keyValueSets) {
        logger.debug("Executing query to determine target entity of {}", (Object)assoc.getQualifiedName());
        StructuredType path = CQL.entity((String)assoc.getDeclaringType().getQualifiedName()).filterByParams(parentKeys).to(assoc.getName());
        Select select = Select.from((StructuredType)path).columns(targetKeys.stream().map(CQL::get));
        Result targetEntries = this.dataStore.execute((CqnSelect)select, Iterables.filter(keyValueSets, entry -> !DeepUpdateSplitter.isDelta((List)DeepUpdateSplitter.getDataFor(assoc, entry))));
        return targetEntries.stream().collect(Collectors.toMap(row -> DeepUpdateSplitter.index((Map<String, Object>)row, targetKeys), Function.identity()));
    }

    private EntityCascader.EntityOperation update(CdsEntity target, Map<String, Object> entry, Map<String, Object> updateData, Map<String, Object> fkValues) {
        EntityCascader.EntityOperation op = EntityCascader.EntityOperation.nop(EntityCascader.EntityKeys.keys(target, entry), null, entry, this.session).update(updateData, fkValues);
        updateData.putAll((Map<String, Object>)((Object)op.targetKeys()));
        return op;
    }

    private void remove(CdsElement association, boolean forwardMapped, CdsEntity targetEntity, Collection<? extends Map<String, Object>> keyValues, String path) {
        if (CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.DELETE, (CdsElement)association)) {
            keyValues.forEach(k -> this.delete(targetEntity, (Map<String, Object>)k, path));
        } else if (!forwardMapped) {
            DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
            Set<String> parentRefElements = DeepUpdateSplitter.refElements(association, forwardMapped);
            keyValues.forEach(k -> this.operations.add(EntityCascader.EntityOperation.nop(EntityCascader.EntityKeys.keys(targetEntity, k), path, this.session).updateToNull(parentRefElements)));
        }
    }

    private void delete(CdsEntity entity, Map<String, Object> data, String path) {
        boolean cascaded;
        EntityCascader.EntityKeys rootKey = EntityCascader.EntityKeys.keys(entity, data);
        CdsEntity target = entity;
        if (path != null) {
            target = (CdsEntity)entity.getTargetOf(path);
        }
        if (!(cascaded = Cascader.create(CdsModelUtils.CascadeType.DELETE, target).from(path).cascade(p -> this.operations.add(EntityCascader.EntityOperation.delete(rootKey, p.asRef().path(), this.session))))) {
            EntityCascader.cascadeDelete(this.dataStore, rootKey, path).forEach(this.operations::add);
        }
        this.operations.add(EntityCascader.EntityOperation.delete(rootKey, path, this.session));
    }

    private EntityCascader.EntityOperation xsert(Map<String, Object> parentData, CdsElement association, boolean forwardMapped, CdsEntity entity, Map<String, Object> entityData, boolean insertOnly) {
        Map<String, Object> fkValues = Collections.emptyMap();
        if (!forwardMapped) {
            fkValues = this.fkValues(association, !forwardMapped, parentData);
        }
        return this.xsert(association, entity, entityData, fkValues, insertOnly);
    }

    private EntityCascader.EntityOperation xsert(CdsElement association, CdsEntity entity, Map<String, Object> entityData, Map<String, Object> fkValues, boolean insertOnly) {
        boolean update;
        HashMap<String, Object> data = new HashMap<String, Object>(entityData);
        data.putAll(fkValues);
        EntityCascader.EntityKeys targetEntity = EntityCascader.EntityKeys.keys(entity, data);
        boolean insert = CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)association);
        boolean bl = update = !insertOnly && CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.UPDATE, (CdsElement)association);
        if (!this.deepUpsert && insert && update && DeepUpdateSplitter.containsStream(entityData)) {
            Select select = Select.from((CdsEntity)entity).columns(new Selectable[]{CQL.plain((String)"1").as("1")}).matching((Map)((Object)targetEntity));
            update = this.dataStore.execute((CqnSelect)select, new Object[0]).rowCount() > 0L;
            boolean bl2 = insert = !update;
        }
        if (insert && update) {
            if (this.deepUpsert || !DeepUpdateSplitter.hasDefaultValues(entity, entityData)) {
                return EntityCascader.EntityOperation.upsert(targetEntity, entityData, fkValues, this.session);
            }
            return EntityCascader.EntityOperation.updateOrInsert(targetEntity, entityData, fkValues, this.session);
        }
        if (insert) {
            return EntityCascader.EntityOperation.insert(targetEntity, entityData, fkValues, this.session);
        }
        if (update) {
            return EntityCascader.EntityOperation.nop(targetEntity, null, this.session).update(entityData, fkValues);
        }
        if (CdsModelUtils.managedToOne((CdsType)association.getType()) && DataUtils.isFkUpdate((CdsElement)association, entityData, (SessionContext)this.session)) {
            return EntityCascader.EntityOperation.nop(targetEntity, null, this.session);
        }
        CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
        throw new CdsDataException(String.format("UPSERT entity '%s' via association '%s.%s' is not allowed. The association does not cascade insert or update.", target, association.getDeclaringType(), association));
    }

    private static boolean containsStream(Map<String, Object> entityData) {
        return entityData.values().stream().anyMatch(v -> v instanceof InputStream || v instanceof Map && DeepUpdateSplitter.containsStream((Map)v));
    }

    private static boolean hasDefaultValues(CdsEntity entity, Map<String, Object> entityData) {
        boolean defaultValue = entity.concreteNonAssociationElements().filter(e -> e.defaultValue().isPresent()).anyMatch(e -> !entityData.containsKey(e.getName()));
        return defaultValue || entity.concreteNonAssociationElements().filter(CdsAnnotatable.byAnnotation((String)"cds.on.insert")).anyMatch(e -> !entityData.containsKey(e.getName()));
    }

    private static void assertCascading(EntityCascader.EntityOperation op, CdsElement association) {
        switch (op.operation()) {
            case INSERT: {
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.INSERT, association);
                break;
            }
            case UPDATE: {
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
                break;
            }
            case DELETE: {
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.DELETE, association);
                break;
            }
            case UPDATE_OR_INSERT: 
            case UPSERT: {
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.UPDATE, association);
                DeepUpdateSplitter.assertCascading(CdsModelUtils.CascadeType.INSERT, association);
            }
        }
    }

    private static void assertCascading(CdsModelUtils.CascadeType cascadeType, CdsElement association) {
        if (!CdsModelUtils.isCascading((CdsModelUtils.CascadeType)cascadeType, (CdsElement)association)) {
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            throw new CdsDataException(String.format("%s entity '%s' via association '%s.%s' is not allowed. The association does not cascade %s.", cascadeType.name(), target, association.getDeclaringType(), association, cascadeType));
        }
    }

    private static Set<String> refElements(CdsElement assoc, boolean forwardMapped) {
        HashMap mapping = new HashMap();
        new OnConditionAnalyzer(assoc, !forwardMapped).getFkMapping().forEach((fk, val) -> {
            if (val.isRef() && !val.asRef().firstSegment().startsWith("$")) {
                mapping.put(fk, val.asRef().lastSegment());
            }
        });
        if (forwardMapped) {
            return new HashSet<String>(mapping.values());
        }
        return new HashSet<String>(mapping.keySet());
    }

    public static <T> T getDataFor(CdsElement assoc, Map<String, Object> data) {
        return (T)DataUtils.getOrDefault(data, (String)assoc.getName(), null);
    }

    public static String index(Map<String, Object> values, Set<String> keys) {
        return values.entrySet().stream().filter(e -> keys.contains(e.getKey())).map(e -> (String)e.getKey() + ":" + e.getValue()).sorted().collect(Collectors.joining("-"));
    }

    private static /* synthetic */ boolean lambda$determineEntries$2(Set targetKeyElements, String k) {
        return !targetKeyElements.contains(k);
    }
}

