/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.SQLDataSourceAdapter;
import com.sap.cds.impl.docstore.DocStoreDeleteStatementBuilder;
import com.sap.cds.impl.docstore.DocStoreSelectStatementBuilder;
import com.sap.cds.impl.docstore.DocStoreUpdateStatementBuilder;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.sql.DeleteStatementBuilder;
import com.sap.cds.impl.sql.InsertStatementBuilder;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.UpdateStatementBuilder;
import com.sap.cds.impl.sql.UpsertStatementBuilder;
import com.sap.cds.ql.cqn.CqnStatement;
import java.util.ArrayDeque;
import java.util.ArrayList;

public class JdbcDataSourceAdapter
implements SQLDataSourceAdapter {
    private static final ArrayDeque<QatSelectableNode> ROOT = new ArrayDeque();
    private final Context context;
    private final DocStoreUtils docStoreUtils;

    public JdbcDataSourceAdapter(Context context) {
        this.context = context;
        this.docStoreUtils = new DocStoreUtils(context.getCdsModel());
    }

    @Override
    public SQLStatementBuilder.SQLStatement process(CqnStatement statement) {
        if (this.docStoreUtils.targetsDocStore(statement)) {
            return this.toHanaDocStoreSQL(statement);
        }
        return this.toSQL(statement);
    }

    private SQLStatementBuilder.SQLStatement toHanaDocStoreSQL(CqnStatement statement) {
        this.assertThatDocStoreSupportIsEnabled();
        Context dsCtx = DocStoreUtils.wrap(this.context);
        if (statement.isSelect()) {
            return new DocStoreSelectStatementBuilder(dsCtx, statement.asSelect()).build();
        }
        if (statement.isInsert()) {
            return DocStoreUtils.getDocStoreInsertStatement(statement.asInsert(), dsCtx);
        }
        if (statement.isUpdate()) {
            return new DocStoreUpdateStatementBuilder(dsCtx, statement.asUpdate()).build();
        }
        if (statement.isDelete()) {
            return new DocStoreDeleteStatementBuilder(dsCtx, statement.asDelete()).build();
        }
        throw new UnsupportedOperationException("Unsupported statement type: " + statement);
    }

    private SQLStatementBuilder.SQLStatement toSQL(CqnStatement statement) {
        if (statement.isSelect()) {
            return new SelectStatementBuilder(this.context, new ArrayList<PreparedCqnStmt.Parameter>(), statement.asSelect(), ROOT).build();
        }
        if (statement.isInsert()) {
            return new InsertStatementBuilder(this.context, statement.asInsert()).build();
        }
        if (statement.isUpsert()) {
            return new UpsertStatementBuilder(this.context, statement.asUpsert()).build();
        }
        if (statement.isUpdate()) {
            return new UpdateStatementBuilder(this.context, statement.asUpdate()).build();
        }
        if (statement.isDelete()) {
            return new DeleteStatementBuilder(this.context, statement.asDelete()).build();
        }
        throw new UnsupportedOperationException("Unsupported statement type: " + statement);
    }

    public void assertThatDocStoreSupportIsEnabled() {
        if (!this.context.getDataStoreConfiguration().getProperty("cds.sql.hana.docstore", false)) {
            throw new UnsupportedOperationException("Can't handle an entity annotated as doc-store enabled: DocStore integration is not enabled.");
        }
    }
}

