/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.google.common.collect.Streams;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.qat.FromClauseBuilder;
import com.sap.cds.impl.qat.QatBuilder;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.Ref2QualifiedColumn;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;

public class SelectStatementBuilder
implements SQLStatementBuilder {
    private final Context context;
    private final CqnSelect select;
    private final Deque<QatSelectableNode> outer;
    private final StatementResolver statementResolver;
    private final SessionContext sessionContext;
    private final List<PreparedCqnStmt.Parameter> params;
    private Ref2QualifiedColumn aliasResolver;
    private TokenToSQLTransformer toSQL;
    private final FromClauseBuilder fromClauseBuilder;
    private final LocaleUtils localeUtils;
    private final CdsEntity targetEntity;
    private final Collating collating;

    public SelectStatementBuilder(Context context, List<PreparedCqnStmt.Parameter> params, CqnSelect select, Deque<QatSelectableNode> outer) {
        this(context, params, select, outer, false);
    }

    public SelectStatementBuilder(Context context, List<PreparedCqnStmt.Parameter> params, CqnSelect select, Deque<QatSelectableNode> outer, boolean noCollating) {
        this.context = context;
        this.params = params;
        this.select = select;
        this.outer = SelectStatementBuilder.append(outer, new QatBuilder(context, select, outer.size()).create());
        this.statementResolver = context.getDbContext().getStatementResolver();
        this.sessionContext = context.getSessionContext();
        this.fromClauseBuilder = new FromClauseBuilder(context, params, select.hints());
        this.localeUtils = new LocaleUtils(context.getCdsModel(), context.getDataStoreConfiguration());
        this.targetEntity = select.from().isRef() ? CdsModelUtils.entity((CdsModel)context.getCdsModel(), (CqnStructuredTypeRef)select.from().asRef()) : null;
        this.collating = SelectStatementBuilder.determineCollating(select, this.localeUtils, this.statementResolver, context.getSessionContext().getLocale(), noCollating);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        this.aliasResolver = new Ref2QualifiedColumn(arg_0 -> ((DbContext)this.context.getDbContext()).getSqlMapping(arg_0), this.outer, this.localeUtils);
        this.toSQL = new TokenToSQLTransformer(this.context, this.params, this.aliasResolver, this.outer, this.collating == Collating.STATEMENT);
        ArrayList<String> snippets = new ArrayList<String>();
        this.with().forEach(snippets::add);
        snippets.add("SELECT");
        this.distinct().forEach(snippets::add);
        this.columns().forEach(snippets::add);
        this.from().forEach(snippets::add);
        this.where().forEach(snippets::add);
        this.groupBy().forEach(snippets::add);
        this.having().forEach(snippets::add);
        this.orderBy().forEach(snippets::add);
        this.limit().forEach(snippets::add);
        this.lock().forEach(snippets::add);
        this.withCollation().ifPresent(snippets::add);
        this.hints().forEach(snippets::add);
        String sql = snippets.stream().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }

    private static boolean hasCollatingOffHint(CqnSelect select) {
        return "off".equals(select.hints().get("collating"));
    }

    private Optional<String> withCollation() {
        if (this.collating == Collating.STATEMENT) {
            Locale locale = this.context.getSessionContext().getLocale();
            return this.statementResolver.statementWideCollation(this.select, locale);
        }
        return Optional.empty();
    }

    private Stream<String> distinct() {
        if (this.select.isDistinct()) {
            return Stream.of("DISTINCT");
        }
        return Stream.empty();
    }

    private Stream<String> columns() {
        List items = this.select.items();
        if (items.isEmpty()) {
            throw new IllegalStateException("select * not expected");
        }
        Stream.Builder sql = Stream.builder();
        items.stream().flatMap(CqnSelectListItem::ofValue).forEach(slv -> {
            sql.add(",");
            sql.add(this.toSQL.apply((CqnToken)slv.value()));
            slv.alias().ifPresent(a -> {
                sql.add("as");
                sql.add(SQLHelper.delimited(a));
            });
        });
        return sql.build().skip(1L);
    }

    private Stream<String> with() {
        return this.fromClauseBuilder.with(this.outer);
    }

    private Stream<String> from() {
        return Streams.concat((Stream[])new Stream[]{Stream.of("FROM"), this.fromClauseBuilder.sql(this.outer)});
    }

    private Stream<String> where() {
        Optional where = Conjunction.and((Optional)this.select.where(), (Optional)this.select.search());
        CqnSource source = this.select.from();
        if (source.isRef()) {
            CqnStructuredTypeRef ref = source.asRef();
            where = Conjunction.and((Optional)where, (Optional)ref.targetSegment().filter());
        }
        if (this.collating == Collating.COLLATE) {
            Locale locale = this.sessionContext.getLocale();
            this.statementResolver.collate(locale).ifPresent(this.aliasResolver::startCollate);
        }
        Stream.Builder sql = Stream.builder();
        where.map(w -> this.toSQL.toSQL((CdsStructuredType)this.targetEntity, (CqnPredicate)w)).ifPresent(s -> {
            sql.add("WHERE");
            sql.add(s);
        });
        this.aliasResolver.stopCollate();
        return sql.build();
    }

    private Stream<String> groupBy() {
        List groupByTokens = this.select.groupBy();
        if (groupByTokens.isEmpty()) {
            return Stream.empty();
        }
        Stream[] streamArray = new Stream[2];
        streamArray[0] = Stream.of("GROUP BY");
        streamArray[1] = SQLStatementBuilder.commaSeparated(groupByTokens.stream(), this.toSQL::apply);
        return Streams.concat((Stream[])streamArray);
    }

    private Stream<String> having() {
        Optional having = this.select.having();
        if (this.collating == Collating.COLLATE) {
            Locale locale = this.sessionContext.getLocale();
            this.statementResolver.collate(locale).ifPresent(this.aliasResolver::startCollate);
        }
        Stream.Builder sql = Stream.builder();
        having.map(h -> this.toSQL.toSQL((CdsStructuredType)this.targetEntity, (CqnPredicate)h)).ifPresent(s -> {
            sql.add("HAVING");
            sql.add(s);
        });
        this.aliasResolver.stopCollate();
        return sql.build();
    }

    private Stream<String> orderBy() {
        List orderBy = this.select.orderBy();
        if (orderBy.isEmpty()) {
            return Stream.empty();
        }
        return Streams.concat((Stream[])new Stream[]{Stream.of("ORDER BY"), SQLStatementBuilder.commaSeparated(orderBy.stream(), this::sort)});
    }

    private String sort(CqnSortSpecification o) {
        StringBuilder sort = new StringBuilder(this.toSQL.apply((CqnToken)o.value()));
        Optional collateClause = this.statementResolver.collate(o, this.sessionContext.getLocale());
        if (this.collating == Collating.COLLATE && collateClause.isPresent() && this.requiresCollate(o.value())) {
            sort.append(" " + (String)collateClause.get());
        }
        switch (o.order()) {
            case DESC: {
                sort.append(" DESC NULLS LAST");
                break;
            }
            case DESC_NULLS_FIRST: {
                sort.append(" DESC NULLS FIRST");
                break;
            }
            case ASC_NULLS_LAST: {
                sort.append(" NULLS LAST");
                break;
            }
            default: {
                sort.append(" NULLS FIRST");
            }
        }
        return sort.toString();
    }

    private boolean requiresCollate(CqnValue value) {
        if (this.targetEntity == null) {
            return false;
        }
        if (value.isRef()) {
            return this.localeUtils.requiresCollate((CdsStructuredType)this.targetEntity, value.asRef());
        }
        return CqnStatementUtils.getCdsType((CdsStructuredType)this.targetEntity, (CqnValue)value).filter(t -> CdsBaseType.STRING == t).isPresent();
    }

    private Stream<String> limit() {
        long top = this.select.top();
        long skip = this.select.skip();
        Stream.Builder<String> sql = Stream.builder();
        if (top < 0L && skip > 0L) {
            top = Integer.MAX_VALUE;
        }
        if (top >= 0L) {
            sql.add("LIMIT");
            sql.add(this.toSQL.apply((CqnToken)CQL.constant((Object)top)));
        }
        if (skip > 0L) {
            sql.add("OFFSET");
            sql.add(this.toSQL.apply((CqnToken)CQL.val((Object)skip)));
        }
        return sql.build();
    }

    private Stream<String> lock() {
        Stream<CqnLock> stream = this.select.getLock().stream();
        return stream.flatMap(arg_0 -> ((StatementResolver)this.statementResolver).lockClause(arg_0));
    }

    private Stream<String> hints() {
        Stream.Builder sql = Stream.builder();
        this.statementResolver.hints(this.select.hints()).ifPresent(sql::add);
        return sql.build();
    }

    private static Deque<QatSelectableNode> append(Deque<QatSelectableNode> prefix, QatSelectableNode newRoot) {
        ArrayDeque<QatSelectableNode> roots = new ArrayDeque<QatSelectableNode>(prefix);
        roots.add(newRoot);
        return roots;
    }

    private static Collating determineCollating(CqnSelect select, LocaleUtils localeUtils, StatementResolver statementResolver, Locale locale, boolean noCollating) {
        if (locale == null || noCollating || SelectStatementBuilder.hasCollatingOffHint(select)) {
            return Collating.OFF;
        }
        return statementResolver.supportsStatementWideCollation() && localeUtils.requiresCollationClause(select, locale) ? Collating.STATEMENT : Collating.COLLATE;
    }

    private static enum Collating {
        STATEMENT,
        COLLATE,
        OFF;

    }
}

