/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.search;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.parser.builder.ExpressionBuilder;
import com.sap.cds.jdbc.hana.search.HanaSearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Locale;
import java.util.Set;

public class HanaSearchResolverUsingScore
extends HanaSearchResolver {
    public HanaSearchResolverUsingScore(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        super(config, cdsModel, locale);
    }

    @Override
    protected CqnPredicate searchToHana(CqnListValue refs, CqnPredicate expression) {
        String searchString = HanaSearchResolverUsingScore.toSearchString(expression);
        Value score = ExpressionBuilder.create((CqnToken[])new CqnToken[0]).plain("SCORE(").val((Object)searchString).plain("IN").add((CqnToken)refs).plain("EXACT)").value();
        return CQL.comparison((CqnValue)score, (CqnComparisonPredicate.Operator)CqnComparisonPredicate.Operator.GT, (CqnValue)CQL.constant((Object)0));
    }

    @Override
    protected boolean needsPushToSubquery(CdsElement element) {
        return false;
    }

    @Override
    protected void handleLocalizedElement(CdsStructuredType targetType, Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> scoreSubquery, Set<CqnElementRef> scoreMainQuery, boolean languageGiven, CqnElementRef ref, CdsElement element) {
        if (languageGiven && HanaSearchResolverUsingScore.isReachableViaLocalizedAssoc(element) && !this.searchLocalizedView(targetType)) {
            scoreSubquery.add(ref);
            scoreSubquery.add(this.localizedRef(ref));
        } else {
            scoreMainQuery.add(ref);
        }
    }

    private boolean searchLocalizedView(CdsStructuredType targetType) {
        String searchMode = (String)targetType.getAnnotationValue("@cds.sql.search.mode", (Object)this.configuredSearchMode());
        return "localized-view".equalsIgnoreCase(searchMode);
    }

    @Override
    protected void handleRegularElement(CdsStructuredType targetType, Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> scoreMainQuery, CqnElementRef ref, CdsElement element) {
        scoreMainQuery.add(ref);
    }

    @Override
    protected void handleLargeStringElement(Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> scoreMainQuery, CdsStructuredType targetType, CqnElementRef ref, CdsElement element) {
        likeMainQuery.add(ref);
    }

    @Override
    protected String defaultSearchMode() {
        return "localized-association";
    }
}

