/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.google.common.collect.Lists;
import com.sap.cds.SessionContext;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.Insert;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OnConditionAnalyzer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DeepInsertSplitter {
    private final CdsEntity entity;
    private final Map<String, List<Map<String, Object>>> insertEntries = new LinkedHashMap<String, List<Map<String, Object>>>();
    private final SessionContext sessionContext;

    public DeepInsertSplitter(CdsModel model, String entityName, SessionContext sessionContext) {
        this(model.getEntity(entityName), sessionContext);
    }

    public DeepInsertSplitter(CdsEntity entity, SessionContext sessionContext) {
        this.entity = entity;
        this.sessionContext = sessionContext;
    }

    public List<Insert> split(List<Map<String, Object>> entries) {
        entries.forEach(entry -> this.flattenEntry(this.entity, (Map<String, Object>)entry));
        return this.computeInserts();
    }

    public List<Insert> split(Map<String, Object> entry) {
        this.flattenEntry(this.entity, entry);
        return this.computeInserts();
    }

    private List<Insert> computeInserts() {
        List inserts = this.insertEntries.entrySet().stream().map(e -> {
            String entity = (String)e.getKey();
            return Insert.into((String)entity).entries((Iterable)e.getValue());
        }).collect(Collectors.toList());
        return Lists.reverse(inserts);
    }

    private void flattenEntry(CdsEntity entity, Map<String, Object> entry) {
        HashMap<String, Object> flatEntry = new HashMap<String, Object>();
        ArrayList toFlatten = new ArrayList();
        entry.forEach((k, v) -> {
            Optional element = entity.findElement(k);
            if (element.map(e -> e.getType().isAssociation() || e.getType().isStructured()).orElse(false).booleanValue()) {
                if (v != null) {
                    toFlatten.add((CdsElement)element.get());
                }
            } else {
                flatEntry.put((String)k, v);
            }
        });
        for (CdsElement element : toFlatten) {
            Object value = entry.get(element.getName());
            if (element.getType().isAssociation()) {
                if (CdsModelUtils.isReverseAssociation((CdsElement)element)) {
                    this.handleReverseAssociation(entity, element, entry, value);
                    continue;
                }
                this.handleForwardAssociation(flatEntry, entry, entity.getName(), value, element);
                continue;
            }
            if (!element.getType().isStructured()) continue;
            flatEntry.put(element.getName(), this.collectStructElement(value, element));
        }
        this.insertEntries.computeIfAbsent(entity.getQualifiedName(), k -> new ArrayList()).add(flatEntry);
    }

    private void handleForwardAssociation(Map<String, Object> flatEntry, Map<String, Object> original, String entityName, Object value, CdsElement association) {
        Map<String, Object> targetValues = DeepInsertSplitter.asMap(entityName, association.getName(), value);
        Map fkValues = new OnConditionAnalyzer(association, false, this.sessionContext).getFkValues(targetValues, false);
        flatEntry.putAll(fkValues);
        fkValues.entrySet().stream().filter(e -> original.containsKey(e.getKey())).forEach(e -> original.put((String)e.getKey(), e.getValue()));
        if (DeepInsertSplitter.cascadeInsert(association)) {
            this.assertInputDataContainsKeys(association, targetValues);
            CdsAssociationType assocType = (CdsAssociationType)association.getType();
            this.flattenEntry(assocType.getTarget(), targetValues);
        } else {
            Set assocKeys = CdsModelUtils.assocKeys((CdsElement)association);
            targetValues.keySet().retainAll(assocKeys);
        }
    }

    private Map<String, Object> collectStructElement(Object value, CdsElement element) {
        HashMap<String, Object> flatEntry = new HashMap<String, Object>();
        Map valueMap = (Map)value;
        CdsStructuredType structElement = (CdsStructuredType)element.getType().as(CdsStructuredType.class);
        structElement.nonAssociationElements().filter(f -> valueMap.keySet().contains(f.getName())).forEach(e -> {
            if (e.getType().isStructured()) {
                flatEntry.put(e.getName(), this.collectStructElement(valueMap.get(e.getName()), (CdsElement)e));
            } else {
                flatEntry.put(e.getName(), valueMap.get(e.getName()));
            }
        });
        structElement.associations().filter(f -> valueMap.keySet().contains(f.getName())).forEach(assoc -> this.handleForwardAssociation((Map<String, Object>)flatEntry, valueMap, element.getDeclaringType().getName(), valueMap.get(assoc.getName()), (CdsElement)assoc));
        return flatEntry;
    }

    private void handleReverseAssociation(CdsEntity entity, CdsElement association, Map<String, Object> entry, Object targetVal) {
        if (DeepInsertSplitter.cascadeInsert(association)) {
            CdsAssociationType assoc = (CdsAssociationType)association.getType();
            Map fkValues = new OnConditionAnalyzer(association, true, this.sessionContext).getFkValues(entry);
            List<Map<String, Object>> targetValues = DeepInsertSplitter.asList(entity.getName(), association.getName(), targetVal);
            for (Map<String, Object> child : targetValues) {
                child.putAll(fkValues);
                this.flattenEntry(assoc.getTarget(), child);
            }
        } else {
            throw new UnsupportedOperationException("Cannot set reference " + entity.getQualifiedName() + "." + association.getName() + ". Reverse associations are not supported.");
        }
    }

    private static boolean cascadeInsert(CdsElement element) {
        return CdsModelUtils.isCascading((CdsModelUtils.CascadeType)CdsModelUtils.CascadeType.INSERT, (CdsElement)element);
    }

    private void assertInputDataContainsKeys(CdsElement association, Map<String, Object> targetValues) {
        CdsAssociationType assoc = (CdsAssociationType)association.getType();
        Set keyNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)assoc.getTarget());
        if (!targetValues.keySet().containsAll(keyNames)) {
            if (DataUtils.isFkUpdate((CdsElement)association, targetValues, (SessionContext)this.sessionContext)) {
                return;
            }
            throw new CdsDataException("Data set " + targetValues.keySet() + " for association " + association.getQualifiedName() + " does not contain values for all target entity keys " + keyNames + ".");
        }
    }

    private static Map<String, Object> asMap(String entityName, String associationName, Object value) {
        try {
            return (Map)value;
        }
        catch (ClassCastException ex) {
            throw DeepInsertSplitter.badValue(entityName, associationName, ex);
        }
    }

    private static List<Map<String, Object>> asList(String entityName, String associationName, Object value) {
        if (value instanceof List) {
            return (List)value;
        }
        if (value instanceof Map) {
            return Collections.singletonList((Map)value);
        }
        throw DeepInsertSplitter.badValue(entityName, associationName, null);
    }

    private static RuntimeException badValue(String entityName, String associationName, RuntimeException cause) {
        return new CdsDataException("Unexpected value: Entity '" + entityName + "' contains unexpected value for the association '" + associationName + "'. ", (Throwable)cause);
    }
}

