/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.ql.impl;

import com.sap.cds.impl.AssociationAnalyzer;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.builder.model.MatchPredicate;
import com.sap.cds.impl.builder.model.StructuredTypeRefImpl;
import com.sap.cds.impl.parser.token.RefSegmentImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredTypeRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnMatchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.ql.impl.ExpressionVisitor;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MatchPredicateNormalizer {
    public static final CqnReference.Segment $OUTER = RefSegmentImpl.refSegment((String)"$outer");
    private final AssociationAnalyzer associationAnalyzer = new AssociationAnalyzer();
    private final CdsModel model;
    private final CdsStructuredType target;

    public MatchPredicateNormalizer(CdsModel model, CdsStructuredType target) {
        this.model = model;
        this.target = target;
    }

    public <S extends CqnStatement> S normalize(S s) {
        s = CQL.copy(s, (Modifier)new Path2Nested());
        s = CQL.copy(s, (Modifier)new Match2Exists());
        return s;
    }

    public Predicate normalize(CqnPredicate pred) {
        Predicate copy = CQL.copy((CqnPredicate)pred, (Modifier)new Path2Nested());
        copy = CQL.copy((CqnPredicate)copy, (Modifier)new Match2Exists());
        return copy;
    }

    private static CdsStructuredType navigate(CdsStructuredType rowType, String id) {
        CdsType type = rowType.getElement(id).getType();
        if (type.isStructured()) {
            return (CdsStructuredType)type.as(CdsStructuredType.class);
        }
        if (type.isAssociation()) {
            return ((CdsAssociationType)type.as(CdsAssociationType.class)).getTarget();
        }
        String message = MessageFormat.format("The reference {0}.{1} does not terminate in an association and can''t be used with the anyMatch predicate.", rowType.getQualifiedName(), id);
        throw new CqnValidationException(message);
    }

    private class Path2Nested
    implements Modifier {
        private Path2Nested() {
        }

        public Predicate match(CqnMatchPredicate match) {
            return this.convertToNestedIfNecessary(MatchPredicateNormalizer.this.target, match.ref(), match.predicate().orElse(null), match.quantifier());
        }

        private Predicate convertToNestedIfNecessary(CdsStructuredType rowType, CqnStructuredTypeRef ref, CqnPredicate pred, CqnMatchPredicate.Quantifier quantifier) {
            List segments = ref.segments();
            int n = segments.size();
            for (int i = 1; i < n; ++i) {
                CqnReference.Segment segment = (CqnReference.Segment)segments.get(i - 1);
                CdsElement element = rowType.getElement(segment.id());
                CdsType elementType = element.getType();
                if (elementType.isStructured()) {
                    rowType = (CdsStructuredType)elementType.as(CdsStructuredType.class);
                    continue;
                }
                if (!elementType.isAssociation()) continue;
                rowType = ((CdsAssociationType)elementType.as(CdsAssociationType.class)).getTarget();
                if (CdsModelUtils.isSingleValued((CdsType)elementType)) continue;
                StructuredTypeRef prefix = StructuredTypeRefImpl.typeRef(segments.subList(0, i), null);
                StructuredTypeRef suffix = StructuredTypeRefImpl.typeRef(segments.subList(i, n), null);
                Predicate nested = this.convertToNestedIfNecessary(rowType, (CqnStructuredTypeRef)suffix, pred, quantifier);
                return MatchPredicate.match((CqnStructuredTypeRef)prefix, (CqnMatchPredicate.Quantifier)quantifier, (CqnPredicate)nested);
            }
            return MatchPredicate.match((CqnStructuredTypeRef)ref, (CqnMatchPredicate.Quantifier)quantifier, (CqnPredicate)pred);
        }
    }

    private class Match2Exists
    implements Modifier {
        private Match2Exists() {
        }

        public CqnStructuredTypeRef ref(CqnStructuredTypeRef ref) {
            return this.resolveInfixFilters(MatchPredicateNormalizer.this.model.getStructuredType(ref.firstSegment()), ref);
        }

        private CqnStructuredTypeRef resolveInfixFilters(CdsStructuredType rowType, CqnStructuredTypeRef ref) {
            Iterator iter = ref.segments().iterator();
            ArrayList<CqnReference.Segment> segments = new ArrayList<CqnReference.Segment>(ref.size());
            CqnReference.Segment seg = (CqnReference.Segment)iter.next();
            segments.add(this.normalizeSegment(seg, rowType));
            while (iter.hasNext()) {
                seg = (CqnReference.Segment)iter.next();
                rowType = MatchPredicateNormalizer.navigate(rowType, seg.id());
                segments.add(this.normalizeSegment(seg, rowType));
            }
            return CQL.to(segments).asRef();
        }

        public CqnSelectListItem expand(CqnExpand expand) {
            this.resolveInfixFilters(MatchPredicateNormalizer.this.target.getTargetOf(expand.ref().firstSegment()), expand.ref());
            return expand;
        }

        public Predicate match(CqnMatchPredicate match) {
            CqnStructuredTypeRef ref = match.ref();
            CqnPredicate pred = match.predicate().orElse(null);
            CqnMatchPredicate.Quantifier quantifier = match.quantifier();
            CdsElement association = this.getAssociation(ref);
            CdsEntity target = ((CdsAssociationType)association.getType().as(CdsAssociationType.class)).getTarget();
            StructuredTypeRef from = this.absoluteRef(target, ref);
            this.rejectToManyPathInFilter(target, pred);
            CqnPredicate where = this.innerToOuter(this.getPrefix(ref), association);
            if (pred != null) {
                pred = this.normalize((CdsStructuredType)target, pred);
                if (quantifier == CqnMatchPredicate.Quantifier.ALL) {
                    pred = CQL.not((CqnPredicate)pred);
                }
                where = Conjunction.and((CqnPredicate)where, (CqnPredicate)pred);
            }
            Select subquery = Select.from((CqnStructuredTypeRef)from).where(where);
            ExistsSubquery exists = new ExistsSubquery((CqnSelect)subquery);
            if (quantifier == CqnMatchPredicate.Quantifier.ALL) {
                return exists.not();
            }
            return exists;
        }

        private void rejectToManyPathInFilter(final CdsEntity entity, CqnPredicate pred) {
            if (pred == null) {
                return;
            }
            CqnVisitor visitor = new CqnVisitor(){

                public void visit(CqnElementRef ref) {
                    CdsEntity structType = entity;
                    for (CqnReference.Segment segment : ref.segments()) {
                        CdsType elType = structType.getElement(segment.id()).getType();
                        if (elType.isStructured()) {
                            structType = (CdsStructuredType)elType.as(CdsStructuredType.class);
                            continue;
                        }
                        if (!elType.isAssociation()) continue;
                        CdsAssociationType assoc = (CdsAssociationType)elType.as(CdsAssociationType.class);
                        structType = assoc.getTarget();
                        if (!CdsModelUtils.isToMany((CdsType)assoc)) continue;
                        String message = MessageFormat.format("Association ''{0}'' with to-many target cardinality in anyMatch/allMatch is not supported", segment.id());
                        throw new CqnValidationException(message);
                    }
                }
            };
            pred.accept(visitor);
        }

        private CqnPredicate innerToOuter(final List<CqnReference.Segment> outerPrefix, final CdsElement association) {
            CqnPredicate on = MatchPredicateNormalizer.this.associationAnalyzer.getOnCondition(association);
            Modifier m = new Modifier(){

                public CqnValue ref(CqnElementRef ref) {
                    ArrayList segments = new ArrayList(ref.segments());
                    if (ref.firstSegment().equals(association.getName())) {
                        segments.remove(0);
                    } else {
                        segments.addAll(0, outerPrefix);
                    }
                    return ElementRefImpl.elementRef(segments, null, null);
                }
            };
            on = ExpressionVisitor.copy((CqnPredicate)on, (Modifier)m);
            return on;
        }

        private StructuredTypeRef absoluteRef(CdsEntity target, CqnStructuredTypeRef ref) {
            CqnPredicate filter = ref.targetSegment().filter().map(ExpressionVisitor::copy).orElse(null);
            return CQL.entity((String)target.getQualifiedName()).filter(filter).asRef();
        }

        private CqnReference.Segment normalizeSegment(CqnReference.Segment seg, CdsStructuredType rowType) {
            CqnPredicate filter = seg.filter().map(f -> this.normalize(rowType, (CqnPredicate)f)).orElse(null);
            return RefSegmentImpl.refSegment((String)seg.id(), (CqnPredicate)filter);
        }

        private Predicate normalize(CdsStructuredType rowType, CqnPredicate pred) {
            return new MatchPredicateNormalizer(MatchPredicateNormalizer.this.model, rowType).normalize(pred);
        }

        private List<CqnReference.Segment> getPrefix(CqnStructuredTypeRef ref) {
            List all = ref.segments();
            int size = all.size();
            List start = all.subList(0, size - 1);
            ArrayList<CqnReference.Segment> prefix = new ArrayList<CqnReference.Segment>(size);
            prefix.add($OUTER);
            prefix.addAll(start);
            return prefix;
        }

        private CdsElement getAssociation(CqnStructuredTypeRef ref) {
            CdsStructuredType rowType = MatchPredicateNormalizer.this.target;
            String root = rowType.getQualifiedName();
            CdsElement element = CdsModelUtils.element((CdsStructuredType)rowType, (List)ref.segments());
            CdsType elementType = element.getType();
            if (!elementType.isAssociation()) {
                String message = MessageFormat.format("The reference {0}.{1} does not terminate in an association and can''t be used with the anyMatch predicate.", root, ref.path());
                throw new CqnValidationException(message);
            }
            return element;
        }
    }
}

