/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.Sets;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.impl.CqnValidator;
import com.sap.cds.impl.DraftUtils;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnValidationException;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CqnValidatorImpl
implements CqnValidator {
    protected final CdsModel cdsModel;
    protected final CqnAnalyzer cqnAnalyzer;
    protected final DocStoreUtils docStoreUtils;

    public CqnValidatorImpl(CdsModel cdsModel) {
        this.cdsModel = cdsModel;
        this.cqnAnalyzer = CqnAnalyzer.create(() -> cdsModel);
        this.docStoreUtils = new DocStoreUtils(cdsModel);
    }

    @Override
    public void validate(CqnSelect query) {
        this.validate(query, CdsDataStoreConnector.Capabilities.ALL);
    }

    @Override
    public void validate(CqnSelect query, CdsDataStoreConnector.Capabilities capabilities) {
        CdsEntity entity;
        if (!capabilities.supportsViewsWithParameters() && query.from().isRef() && (entity = CdsModelUtils.entity((CdsModel)this.cdsModel, (CqnStructuredTypeRef)query.from().asRef())).isView() && entity.params().count() > 0L) {
            throw new UnsupportedOperationException("Parametrized views are not supported by this data store");
        }
    }

    @Override
    public void validate(CqnInsert insert) {
        if (this.docStoreUtils.targetsDocStore((CqnStatement)insert)) {
            return;
        }
        this.validateElements(this.cqnAnalyzer.analyze(insert.ref()).targetEntity(), insert.elements());
    }

    @Override
    public void validate(CqnUpdate update) {
        if (this.docStoreUtils.targetsDocStore((CqnStatement)update)) {
            this.assertThatAllEntriesHaveSameStructure(update);
            return;
        }
        this.validateElements(this.cqnAnalyzer.analyze(update.ref()).targetEntity(), update.elements());
        CdsStructuredType targetType = CqnStatementUtils.rowType((CdsModel)this.cdsModel, (CqnSource)update.ref());
        update.where().ifPresent(w -> w.accept((CqnVisitor)new VirtualElementValidator(targetType)));
    }

    @Override
    public void validate(CqnUpsert upsert) {
        CdsEntity entity = this.cqnAnalyzer.analyze(upsert.ref()).targetEntity();
        Set keyNames = CdsModelUtils.concreteKeyNames((CdsStructuredType)entity);
        if (DraftUtils.isDraftEnabled((CdsStructuredType)entity) && !DraftUtils.isDraftView((CdsStructuredType)entity)) {
            keyNames.remove("IsActiveEntity");
        }
        if (!upsert.elements().collect(Collectors.toSet()).containsAll(keyNames)) {
            Sets.SetView missingKeys = Sets.difference((Set)keyNames, upsert.elements().collect(Collectors.toSet()));
            throw new CdsDataException("Missing key value for " + (Set)missingKeys);
        }
    }

    private void assertThatAllEntriesHaveSameStructure(CqnUpdate update) {
        Set elements = update.data().keySet();
        if (!update.entries().stream().allMatch(e -> e.keySet().equals(elements))) {
            String allElements = update.elements().collect(Collectors.joining(", ", "[", "]"));
            throw new UnsupportedOperationException("Each bulk update entry must contain values for the same elements " + allElements);
        }
    }

    private void validateElements(CdsEntity entity, Stream<String> usedElements) {
        if (entity.findAnnotation("open").isEmpty()) {
            usedElements.forEach(element -> {
                String rootElement;
                int firstDot = element.indexOf(46);
                String string = rootElement = firstDot == -1 ? element : element.substring(0, firstDot);
                if (!entity.findElement(rootElement).isPresent() && !entity.findElement(element).isPresent()) {
                    throw new CqnValidationException("Element '" + element + "' does not exist in entity '" + entity.getQualifiedName() + "'");
                }
            });
        }
    }

    @Override
    public void validate(CqnDelete delete) {
        CdsStructuredType targetType = CqnStatementUtils.rowType((CdsModel)this.cdsModel, (CqnSource)delete.ref());
        delete.where().ifPresent(w -> w.accept((CqnVisitor)new VirtualElementValidator(targetType)));
    }

    public static RuntimeException virtualElementException(String element) {
        return new CqnValidationException("Virtual element '%s' is not allowed in filter conditions".formatted(element));
    }

    private class VirtualElementValidator
    implements CqnVisitor {
        private CdsStructuredType root;

        public VirtualElementValidator(CdsStructuredType rowType) {
            this.root = rowType;
        }

        public void visit(CqnElementRef ref) {
            if ("$key".equals(ref.lastSegment()) || CdsModelUtils.isEtagPlaceholder((CqnElementRef)ref) || CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                return;
            }
            if (CdsModelUtils.element((CdsStructuredType)this.root, (CqnElementRef)ref).isVirtual()) {
                throw CqnValidatorImpl.virtualElementException(ref.displayName());
            }
        }
    }
}

