/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.Cds4jServiceLoader;
import com.sap.cds.CdsCommunicationException;
import com.sap.cds.CdsDataStoreException;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.DbContextFactory;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.function.Supplier;

public class DbContextFactoryRegister {
    private static final ThreadLocal<Collection<DbContextFactory>> registeredCandidates = ThreadLocal.withInitial(() -> Cds4jServiceLoader.loadAll(DbContextFactory.class));

    private DbContextFactoryRegister() {
    }

    public static DbContext context(DataStoreConfiguration dataStoreConfiguration, Supplier<Connection> ds) {
        DbContext dbContext;
        block8: {
            Connection conn = ds.get();
            try {
                DatabaseMetaData metaData = conn.getMetaData();
                String productName = metaData.getDatabaseProductName();
                int majorVersion = metaData.getDatabaseMajorVersion();
                dbContext = DbContextFactoryRegister.context(dataStoreConfiguration, productName, majorVersion);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new CdsCommunicationException("Cannot obtain connection to DB", (Throwable)e);
                }
            }
            conn.close();
        }
        return dbContext;
    }

    @VisibleForTesting
    static DbContext context(DataStoreConfiguration dataStoreConfiguration, String productName, int majorVersion) {
        return registeredCandidates.get().stream().filter(f -> f.supports(productName)).map(f -> f.create(dataStoreConfiguration, majorVersion)).findFirst().orElseThrow(() -> new CdsDataStoreException("Unsupported DB " + productName));
    }
}

