/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.impl.CdsDataStoreImpl;
import com.sap.cds.impl.InlineCountProcessor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.Modifier;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.util.CqnStatementUtils;
import java.util.List;
import java.util.Map;

public class InlineCountProcessorFactory {
    private final CdsDataStoreImpl dataStore;
    private final DataStoreConfiguration cfg;
    private static final InlineCountProcessor noOp = new InlineCountProcessor(){};
    private static final InlineCountProcessor rowCounter = new InlineCountProcessor(){

        @Override
        public ResultBuilder execute(ResultBuilder result, Map<String, Object> paramValues) {
            result.inlineCount(result.rowCount());
            return result;
        }
    };

    InlineCountProcessorFactory(CdsDataStoreImpl dataStore, DataStoreConfiguration cfg) {
        this.dataStore = dataStore;
        this.cfg = cfg;
    }

    public InlineCountProcessor create(CqnSelect query) {
        String inlineCountConfig;
        if (!query.hasInlineCount()) {
            return noOp;
        }
        if (!query.hasLimit()) {
            return rowCounter;
        }
        return switch (inlineCountConfig = this.cfg.getProperty("cds.sql.inlineCount", "auto")) {
            case "query" -> new QueryProcessor(query);
            case "window-function" -> new WindowFunctionProcessor(query);
            default -> !InlineCountProcessorFactory.hasFilter(query) ? new QueryProcessor(query) : new WindowFunctionProcessor(query);
        };
    }

    private static boolean hasFilter(CqnSelect query) {
        return query.where().isPresent() || query.search().isPresent() || query.from().isRef() && query.ref().targetSegment().filter().isPresent();
    }

    @VisibleForTesting
    static boolean requiresInlineCountQuery(long top, long skip, long rowCount) {
        return skip > 0L || top <= rowCount;
    }

    private class QueryProcessor
    implements InlineCountProcessor {
        private CqnSelect select;

        QueryProcessor(CqnSelect select) {
            this.select = select;
        }

        @Override
        public ResultBuilder execute(ResultBuilder result, Map<String, Object> paramValues) {
            long rowCount = result.rowCount();
            if (InlineCountProcessorFactory.requiresInlineCountQuery(this.select.top(), this.select.skip(), rowCount)) {
                result.inlineCount(this.executeInlineCountQuery(this.select, paramValues));
            } else {
                result.inlineCount(rowCount);
            }
            return result;
        }

        private long executeInlineCountQuery(CqnSelect select, Map<String, Object> paramValues) {
            CqnSelect inlineCountQuery = QueryProcessor.inlineCountQuery(select);
            Result result = InlineCountProcessorFactory.this.dataStore.executeResolvedQuery(inlineCountQuery, paramValues).result();
            return ((CqnStatementUtils.Count)result.single(CqnStatementUtils.Count.class)).getCount();
        }

        private static CqnSelect inlineCountQuery(CqnSelect select) {
            Select countQuery = Select.from((CqnStructuredTypeRef)select.ref());
            select.where().ifPresent(arg_0 -> ((Select)countQuery).where(arg_0));
            select.search().ifPresent(arg_0 -> ((Select)countQuery).search(arg_0));
            select.having().ifPresent(arg_0 -> ((Select)countQuery).having(arg_0));
            if (select.isDistinct() || !select.groupBy().isEmpty()) {
                countQuery.columns(select.items());
                countQuery.groupBy(select.groupBy());
                countQuery.distinct();
                countQuery = Select.from((CqnSelect)countQuery);
            }
            return countQuery.columns(new Selectable[]{CqnStatementUtils.Count.ALL});
        }
    }

    private class WindowFunctionProcessor
    implements InlineCountProcessor {
        private static final String $COUNT = "_$count";
        private static final CqnSelectListValue COUNT_ALL_OVER = CQL.plain((String)"COUNT(*) OVER()").type(CdsBaseType.INT64).as("_$count");
        private final CqnSelect select;

        WindowFunctionProcessor(CqnSelect select) {
            this.select = select;
        }

        @Override
        public CqnSelect prepare(CqnSelect select) {
            return (CqnSelect)CQL.copy((CqnStatement)select, (Modifier)new Modifier(){

                public List<CqnSelectListItem> items(List<CqnSelectListItem> items) {
                    items.add((CqnSelectListItem)COUNT_ALL_OVER);
                    return items;
                }
            });
        }

        @Override
        public ResultBuilder execute(ResultBuilder result, Map<String, Object> paramValues) {
            if (result.rowCount() == 0L && this.select.skip() > 0L) {
                return new QueryProcessor(this.select).execute(result, paramValues);
            }
            Result tmpResult = result.result();
            long inlineCount = tmpResult.first().map(r -> (Long)r.get((Object)$COUNT)).orElse(0L);
            result.inlineCount(inlineCount);
            tmpResult.stream().forEach(r -> r.remove((Object)$COUNT));
            return result;
        }
    }
}

