/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsDataStoreException;
import com.sap.cds.CdsMissingValueException;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.impl.ExpandProcessor;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsTypeUtils;
import java.io.IOException;
import java.io.PipedReader;
import java.io.PipedWriter;
import java.io.Reader;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.function.Supplier;

public class PreparedCqnStmt
implements PreparedCqnStatement {
    private final CqnStructuredTypeRef ref;
    private final CdsStructuredType targetType;
    private final String nativeStatement;
    private final List<CqnSelectListItem> selectListItems;
    private final List<ExpandProcessor> expands;
    private final List<String> excluding;
    private final List<Parameter> params;
    private Function<SQLException, PreparedCqnStmt> fallback = e -> null;

    private PreparedCqnStmt(CqnStructuredTypeRef ref, CdsStructuredType targetType, String nativeStatement, List<CqnSelectListItem> selectListItems, List<ExpandProcessor> expands, List<String> excluding, List<Parameter> parameters) {
        this.ref = ref;
        this.targetType = targetType;
        this.nativeStatement = nativeStatement;
        this.params = parameters;
        this.selectListItems = selectListItems;
        this.expands = expands;
        this.excluding = excluding;
    }

    public static PreparedCqnStmt create(String nativeStatement, List<CqnSelectListItem> selectListItems, List<ExpandProcessor> expands, List<String> excluding, List<Parameter> parameters, CqnStructuredTypeRef ref, CdsStructuredType targetType) {
        return new PreparedCqnStmt(ref, targetType, nativeStatement, selectListItems, expands, excluding, parameters);
    }

    public static PreparedCqnStmt createUpdate(String nativeStatement, List<Parameter> parameters, CqnStructuredTypeRef ref, CdsEntity entity) {
        return new PreparedCqnStmt(ref, (CdsStructuredType)entity, nativeStatement, Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), parameters);
    }

    public void setFallback(Function<SQLException, PreparedCqnStmt> fallback) {
        this.fallback = fallback;
    }

    Optional<PreparedCqnStmt> prepareFallback(SQLException e) {
        return Optional.ofNullable(this.fallback.apply(e));
    }

    protected String toNative() {
        return this.nativeStatement;
    }

    public List<CqnSelectListItem> selectListItems() {
        return Collections.unmodifiableList(this.selectListItems);
    }

    public List<ExpandProcessor> expands() {
        return this.expands;
    }

    public List<String> excluding() {
        return Collections.unmodifiableList(this.excluding);
    }

    public <T extends CdsStructuredType> T targetType() {
        return (T)this.targetType;
    }

    public CqnStructuredTypeRef ref() {
        return this.ref;
    }

    public String toString() {
        return this.nativeStatement;
    }

    public List<Parameter> parameters() {
        return this.params;
    }

    private static Map<String, Object> asMap(Object result) {
        try {
            return (Map)result;
        }
        catch (ClassCastException e) {
            throw new CdsDataException("Data has unexpected type " + result.getClass().getName(), (Throwable)e);
        }
    }

    public static class JsonParam
    extends Parameter {
        @Override
        public Reader get(Map<String, Object> map) {
            try {
                PipedWriter writer = new PipedWriter();
                PipedReader reader = new PipedReader(writer);
                CompletableFuture.runAsync(() -> {
                    try {
                        Jsonizer.write((Writer)writer, (Object)map);
                    }
                    catch (IOException e) {
                        throw new CdsDataException("Failed to serialize JSON data parameter: ", (Throwable)e);
                    }
                });
                return reader;
            }
            catch (IOException e) {
                throw new CdsDataStoreException("IO Exception during serialization of JSON content", (Throwable)e);
            }
        }

        @Override
        public CdsBaseType type() {
            return CdsBaseType.LARGE_STRING;
        }

        @Override
        public String name() {
            return "$json";
        }
    }

    public static class ValueParam
    extends Parameter {
        final Supplier<Object> valueSupplier;

        public ValueParam(Supplier<Object> valueSupplier) {
            this.valueSupplier = valueSupplier;
        }

        @Override
        public Object get(Map<String, Object> cqnParameters) {
            return this.valueSupplier.get();
        }

        @Override
        public String name() {
            return this.valueSupplier != null ? this.valueSupplier.get().toString() : "null";
        }
    }

    public static class DataParam
    extends Parameter {
        private final String name;
        private final String[] segs;

        public DataParam(String name, CdsBaseType type) {
            this.name = name;
            this.type = type;
            this.segs = name.split("\\.");
        }

        @Override
        public Object get(Map<String, Object> values) {
            if (values == null) {
                return null;
            }
            Object result = values;
            for (String seg : this.segs) {
                if ((result = PreparedCqnStmt.asMap(result).get(seg)) != null) continue;
                return null;
            }
            return result;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    public static class CqnParam
    extends Parameter {
        final String name;
        final Object defaultValue;

        public CqnParam(String name) {
            this(name, null);
        }

        public CqnParam(String name, Object defaultValue) {
            this.name = name;
            this.defaultValue = defaultValue;
        }

        @Override
        public Object get(Map<String, Object> values) {
            if (values.containsKey(this.name)) {
                Object value = values.get(this.name);
                if (this.type == CdsBaseType.UUID) {
                    value = CdsTypeUtils.parseUuid((Object)value);
                }
                return value;
            }
            if (this.defaultValue != null) {
                return this.defaultValue;
            }
            throw new CdsMissingValueException(this.name);
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Optional<Object> defaultValue() {
            return Optional.ofNullable(this.defaultValue);
        }
    }

    public static abstract class Parameter {
        protected CdsBaseType type;

        public abstract Object get(Map<String, Object> var1);

        public abstract String name();

        public Optional<Object> defaultValue() {
            return Optional.empty();
        }

        public CdsBaseType type() {
            return this.type;
        }

        public String toString() {
            return this.name();
        }

        public Parameter type(Optional<String> type) {
            this.type = type.map(CdsBaseType::cdsType).orElse(null);
            return this;
        }

        public Parameter type(CdsBaseType type) {
            this.type = type;
            return this;
        }
    }
}

