/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.docstore;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.docstore.DocStoreStatementBuilder;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class DocStoreDeleteStatementBuilder
implements DocStoreStatementBuilder {
    private final CqnDelete delete;
    private final TokenToSQLTransformer toSql;
    private final SqlMapping sqlMapping;
    private final String tableName;
    private final CdsEntity entity;
    private final List<PreparedCqnStmt.Parameter> params = new ArrayList<PreparedCqnStmt.Parameter>();

    public DocStoreDeleteStatementBuilder(Context context, CqnDelete delete) {
        this.delete = delete;
        this.entity = context.getCdsModel().getEntity(this.delete.ref().firstSegment());
        this.sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)this.entity);
        this.tableName = this.sqlMapping.tableName();
        this.toSql = TokenToSQLTransformer.notCollating(context, arg_0 -> ((SqlMapping)this.sqlMapping).columnName(arg_0), this.entity, this.tableName, this.params, DocStoreUtils::valueToParamCastExpression);
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        Stream.Builder<String> builder = Stream.builder();
        builder.add("DELETE FROM");
        builder.add(this.tableName);
        this.delete.where().map(this.toSql::toSQL).ifPresent(whereSql -> {
            builder.add("WHERE");
            builder.add((String)whereSql);
        });
        String sql = builder.build().collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, this.params);
    }
}

