/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsSearchUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSearchResolver
implements SearchResolver {
    private static final Logger logger = LoggerFactory.getLogger(AbstractSearchResolver.class);
    private static final String LOCALIZED = "localized";
    private final DataStoreConfiguration config;
    protected final CdsModel model;
    protected final Locale locale;

    protected AbstractSearchResolver(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        this.config = config;
        this.model = cdsModel;
        this.locale = locale;
    }

    protected abstract String defaultSearchMode();

    protected String configuredSearchMode() {
        return this.config.getProperty("cds.sql.search.mode", this.defaultSearchMode());
    }

    protected String searchMode(CdsStructuredType targetType) {
        return (String)targetType.getAnnotationValue("@cds.sql.search.mode", (Object)this.configuredSearchMode());
    }

    public CqnSelect resolve(CqnSelect select) {
        select.search().ifPresent(search -> {
            if (logger.isDebugEnabled()) {
                logger.debug("Starting resolution of the following search operation: {}", (Object)select.toJson());
            }
            CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.model, (CqnSelect)select);
            Collection searchableRefs = CdsSearchUtils.getSearchableElements((CqnSelect)select, (CdsStructuredType)targetType);
            if ("generic".equalsIgnoreCase(this.searchMode(targetType))) {
                this.resolveUsingLocalizedViewWithLike(select, (CqnPredicate)search, targetType, searchableRefs);
            } else {
                this.resolve(select, (CqnPredicate)search, targetType, searchableRefs);
            }
            logger.debug("Finished resolution of search with this result: {}", (Object)select);
        });
        return select;
    }

    protected abstract void resolve(CqnSelect var1, CqnPredicate var2, CdsStructuredType var3, Collection<CqnElementRef> var4);

    protected static CqnPredicate wrapIntoExistsSubquery(CdsEntity target, CqnPredicate search, boolean ignoreLocalizedViews) {
        CqnPredicate toOuter = CqnStatementUtils.linkKeysToOuterQuery((CdsStructuredType)target);
        Select subquery = Select.from((CdsEntity)target).where(Conjunction.and((CqnPredicate)toOuter, (CqnPredicate)search));
        if (ignoreLocalizedViews) {
            subquery.hint("ignoreLocalizedViews", (Object)true);
        }
        subquery.hint("ignoreDraftSubqueries", (Object)true);
        return new ExistsSubquery((CqnSelect)subquery);
    }

    protected static boolean anyRefViaCollectionAssociation(CdsStructuredType root, Collection<CqnElementRef> refs) {
        for (CqnElementRef ref : refs) {
            List prefix;
            List segments = ref.segments();
            if (segments.size() <= 1 || CqnStatementUtils.isToOnePath((CdsStructuredType)root, prefix = segments.subList(0, segments.size() - 1))) continue;
            return true;
        }
        return false;
    }

    protected static boolean navigatesToManyAssoc(CdsStructuredType root, CqnElementRef ref) {
        List segments = ref.segments();
        List prefix = segments.subList(0, segments.size() - 1);
        return !CqnStatementUtils.isToOnePath((CdsStructuredType)root, prefix);
    }

    protected static CqnPredicate pushDownToExistsSubquery(CdsStructuredType targetType, CqnPredicate filter, boolean ignoreLocalizedViews) {
        if (filter == CqnBoolLiteral.FALSE) {
            return CqnBoolLiteral.FALSE;
        }
        if (!(targetType instanceof CdsEntity)) {
            throw new UnsupportedOperationException("A path expression used in search must originate from an entity");
        }
        CdsEntity targetEntity = (CdsEntity)targetType;
        filter = AbstractSearchResolver.wrapIntoExistsSubquery(targetEntity, filter, ignoreLocalizedViews);
        return filter;
    }

    protected boolean allLocalizedElementsAreReachableViaLocalizedAssociation(CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs, Collection<CqnElementRef> badRefs) {
        Collection notReachableViaLocalizedRefs = searchableRefs.stream().filter(ref -> AbstractSearchResolver.localizedButNotReachableViaLocalizedRef(targetType, ref)).collect(Collectors.toSet());
        if (!notReachableViaLocalizedRefs.isEmpty()) {
            logger.warn("Detected one or more localized elements in entity/view {} that is not reachable corresponding 'localized' association: {}. Search will fall back to LIKE and localized views.", (Object)targetType, (Object)notReachableViaLocalizedRefs);
            badRefs.addAll(notReachableViaLocalizedRefs);
            return false;
        }
        return true;
    }

    private static boolean localizedButNotReachableViaLocalizedRef(CdsStructuredType targetType, CqnElementRef ref) {
        CdsElement element = CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)ref);
        if (!element.isLocalized()) {
            return false;
        }
        return !AbstractSearchResolver.isReachableViaLocalizedAssoc(element);
    }

    protected static boolean isReachableViaLocalizedAssoc(CdsElement element) {
        Optional localizedAssoc = ((CdsStructuredType)element.getDeclaringType().as(CdsStructuredType.class)).findAssociation(LOCALIZED);
        if (localizedAssoc.isEmpty()) {
            return false;
        }
        CdsEntity texts = ((CdsAssociationType)((CdsElement)localizedAssoc.get()).getType().as(CdsAssociationType.class)).getTarget();
        return texts.findElement(element.getName()).isPresent();
    }

    public List<CqnElementRef> addRefsViaLocalizedAssociation(CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs) {
        ArrayList<CqnElementRef> allSearchableRefs = new ArrayList<CqnElementRef>(searchableRefs);
        searchableRefs.stream().filter(ref -> CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)ref).isLocalized()).map(this::localizedRef).forEach(allSearchableRefs::add);
        return this.deduplicate(allSearchableRefs);
    }

    protected CqnElementRef localizedRef(CqnElementRef ref) {
        LinkedList<CqnReference.Segment> searchSegments = new LinkedList<CqnReference.Segment>(ref.segments());
        searchSegments.add(searchSegments.size() - 1, CQL.refSegment((String)LOCALIZED));
        return CQL.get(searchSegments);
    }

    protected boolean hasAliasedLocalizedElementsInView(CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs, Collection<CqnElementRef> badRefs) {
        Set aliasedLocalizedElement;
        if (!(targetType instanceof CdsEntity)) {
            return false;
        }
        Optional query = ((CdsEntity)targetType).query();
        if (query.isPresent() && !(aliasedLocalizedElement = ((CqnSelect)query.get()).items().stream().filter(i -> i.isRef() && i.asValue().alias().isPresent()).filter(i -> this.isSearchable((CqnSelectListItem)i, searchableRefs)).filter(i -> CdsModelUtils.findElement((CdsStructuredType)targetType, (CqnElementRef)i.asValue().value().asRef()).isPresent()).filter(i -> this.isElementBehindRefLocalized((CqnSelectListItem)i, targetType)).map(i -> i.asValue().value().asRef()).peek(i -> logger.debug("found aliased localized element {} in {} that consequently cannot be rendered with CONTAINS.", i, (Object)targetType)).collect(Collectors.toSet())).isEmpty()) {
            badRefs.addAll(aliasedLocalizedElement);
            return true;
        }
        return false;
    }

    private boolean isElementBehindRefLocalized(CqnSelectListItem sli, CdsStructuredType targetType) {
        CdsElement element = CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)sli.asRef());
        return element.isLocalized();
    }

    protected boolean isSearchable(CqnSelectListItem sli, Collection<CqnElementRef> searchableRefs) {
        return searchableRefs.stream().anyMatch(s -> s.asValue().displayName().equals(sli.asValue().displayName()));
    }

    private List<CqnElementRef> deduplicate(List<CqnElementRef> allSearchableRefs) {
        HashSet paths = new HashSet(allSearchableRefs.size());
        return allSearchableRefs.stream().filter(r -> paths.add(r.path())).collect(Collectors.toList());
    }

    protected void resolveUsingLocalizedViewWithLike(CqnSelect select, CqnPredicate expression, CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs) {
        CqnPredicate filter = CdsSearchUtils.searchToLikeExpression(searchableRefs, (CqnPredicate)expression);
        if (AbstractSearchResolver.anyRefViaCollectionAssociation(targetType, searchableRefs)) {
            filter = AbstractSearchResolver.pushDownToExistsSubquery(targetType, filter, false);
        }
        CdsSearchUtils.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }

    protected void resolveUsingLocalizedAssociationWithLike(CqnSelect select, CqnPredicate expression, CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs) {
        List<CqnElementRef> allSearchableRefs = this.addRefsViaLocalizedAssociation(targetType, searchableRefs);
        CqnPredicate filter = CdsSearchUtils.searchToLikeExpression(allSearchableRefs, (CqnPredicate)expression);
        filter = AbstractSearchResolver.pushDownToExistsSubquery(targetType, filter, true);
        CdsSearchUtils.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }
}

