/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleNameTableNameResolver
implements TableNameResolver {
    private static final Logger logger = LoggerFactory.getLogger(LocaleNameTableNameResolver.class);
    private static final String DEFAULT_SUPPORTED_LOCALES = "de,fr";
    private final Function<CdsStructuredType, SqlMapping> mapping;
    protected final DataStoreConfiguration dataStoreConfiguration;
    protected final Locale locale;

    public LocaleNameTableNameResolver(Function<CdsStructuredType, SqlMapping> mapping, DataStoreConfiguration dataStoreConfiguration, Locale locale) {
        this.mapping = mapping;
        this.dataStoreConfiguration = dataStoreConfiguration;
        this.locale = locale;
    }

    public String tableName(CdsEntity entity) {
        SqlMapping sqlMapping = this.mapping.apply((CdsStructuredType)entity);
        String entityName = entity.getQualifiedName();
        if (this.locale == null || !LocaleUtils.isLocalized((CdsEntity)entity)) {
            String tableName = sqlMapping.tableName();
            logger.debug("No locale set. Resolve {} to plain table {}.", (Object)entityName, (Object)tableName);
            return tableName;
        }
        if (this.hasLocaleSpecificView(this.locale)) {
            String localeSpecifcViewName = LocaleUtils.localeSpecificViewName((String)entityName, (Locale)this.locale);
            logger.debug("Locale is {}. Resolve {} using locale-specific view {}.", new Object[]{this.locale.toLanguageTag(), entityName, localeSpecifcViewName});
            return sqlMapping.plainTableName(localeSpecifcViewName);
        }
        String localizedViewName = sqlMapping.localizedViewName();
        logger.debug("Locale is {}. There is no corresponding locale-specific view. Resolve {} using generic localized view {}.", new Object[]{this.locale.toLanguageTag(), entityName, localizedViewName});
        return localizedViewName;
    }

    private boolean hasLocaleSpecificView(Locale locale) {
        if (locale == null) {
            return false;
        }
        String supportedLocales = this.dataStoreConfiguration.getProperty("supported_locales", DEFAULT_SUPPORTED_LOCALES);
        return Arrays.asList(supportedLocales.split(",")).contains(LocaleUtils.getLocaleString((Locale)locale));
    }
}

