/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Locale;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocaleVariableTableNameResolver
implements TableNameResolver {
    private static final Logger logger = LoggerFactory.getLogger(LocaleVariableTableNameResolver.class);
    private final Function<CdsStructuredType, SqlMapping> mapping;
    private final Locale locale;

    public LocaleVariableTableNameResolver(Function<CdsStructuredType, SqlMapping> mapping, Locale locale) {
        this.mapping = mapping;
        this.locale = locale;
    }

    public String tableName(CdsEntity entity) {
        SqlMapping sqlMapping = this.mapping.apply((CdsStructuredType)entity);
        String entityName = entity.getQualifiedName();
        if (LocaleUtils.isLocalized((CdsEntity)entity) && this.locale != null) {
            String localizedViewName = sqlMapping.localizedViewName();
            logger.debug("Locale is {}. Resolve {} using generic localized view {}.", new Object[]{this.locale.toLanguageTag(), entityName, localizedViewName});
            return localizedViewName;
        }
        String tableName = sqlMapping.tableName();
        logger.debug("No locale set. Resolve {} to plain table {}.", (Object)entityName, (Object)tableName);
        return tableName;
    }
}

