/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.search;

import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.builder.model.ListValue;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.jdbc.generic.AbstractSearchResolver;
import com.sap.cds.jdbc.hana.search.HanaSearchResolverUsingContains;
import com.sap.cds.jdbc.hana.search.HanaSearchResolverUsingScore;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSearchPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsSearchUtils;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HanaSearchResolver
extends AbstractSearchResolver {
    private static final Logger logger = LoggerFactory.getLogger(HanaSearchResolver.class);

    protected HanaSearchResolver(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        super(config, cdsModel, locale);
    }

    public static HanaSearchResolver forLegacyEngine(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        return new HanaSearchResolverUsingContains(config, cdsModel, locale);
    }

    public static SearchResolver forHexEngine(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        return new HanaSearchResolverUsingScore(config, cdsModel, locale);
    }

    @Override
    protected void resolve(CqnSelect select, CqnPredicate search, CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs) {
        TreeSet<CqnElementRef> likeMainQuery = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        TreeSet<CqnElementRef> subquery = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        TreeSet<CqnElementRef> mainQuery = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        boolean languageGiven = this.locale != null;
        boolean pushToSubquery = false;
        boolean navigatesToManyAssoc = false;
        for (CqnElementRef ref : searchableRefs) {
            CdsElement element = CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)ref);
            CdsType type = element.getType();
            if (type.isSimpleType(CdsBaseType.LARGE_STRING) || type.isSimpleType(CdsBaseType.HANA_CLOB)) {
                this.handleLargeStringElement(likeMainQuery, mainQuery, targetType, ref, element);
            } else if (element.isLocalized()) {
                this.handleLocalizedElement(targetType, likeMainQuery, subquery, mainQuery, languageGiven, ref, element);
            } else {
                this.handleRegularElement(targetType, likeMainQuery, mainQuery, ref, element);
            }
            pushToSubquery = pushToSubquery || this.needsPushToSubquery(element);
            navigatesToManyAssoc = navigatesToManyAssoc || HanaSearchResolver.navigatesToManyAssoc(targetType, ref);
        }
        this.attachContainsAndLikeExpressionsToStatement(select, search, targetType, likeMainQuery, subquery, mainQuery, pushToSubquery, navigatesToManyAssoc);
    }

    protected abstract void handleLargeStringElement(Set<CqnElementRef> var1, Set<CqnElementRef> var2, CdsStructuredType var3, CqnElementRef var4, CdsElement var5);

    protected abstract void handleLocalizedElement(CdsStructuredType var1, Set<CqnElementRef> var2, Set<CqnElementRef> var3, Set<CqnElementRef> var4, boolean var5, CqnElementRef var6, CdsElement var7);

    protected abstract void handleRegularElement(CdsStructuredType var1, Set<CqnElementRef> var2, Set<CqnElementRef> var3, CqnElementRef var4, CdsElement var5);

    private void attachContainsAndLikeExpressionsToStatement(CqnSelect select, CqnPredicate search, CdsStructuredType targetType, Set<CqnElementRef> likeMainQuery, Set<CqnElementRef> containsSubquery, Set<CqnElementRef> containsMainQuery, boolean pushToSubquery, boolean navigatesToManyAssoc) {
        CqnBoolLiteral filter = CqnBoolLiteral.FALSE;
        TreeSet<CqnElementRef> containsRefs = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        containsRefs.addAll(containsMainQuery);
        containsRefs.addAll(containsSubquery);
        if (logger.isDebugEnabled() && !containsRefs.isEmpty()) {
            String names = this.refNames(containsRefs);
            logger.debug("The following searchable element refs of {} that can be searched with CONTAINS: {}.", (Object)targetType, (Object)names);
        }
        CqnPredicate searchPredicate = this.searchToHana(containsRefs, search);
        if (navigatesToManyAssoc || !containsSubquery.isEmpty() || !likeMainQuery.isEmpty() || pushToSubquery) {
            searchPredicate = HanaSearchResolver.pushDownToExistsSubquery(targetType, searchPredicate, true);
        }
        filter = CQL.or((CqnPredicate)filter, (CqnPredicate)searchPredicate);
        if (logger.isDebugEnabled() && !likeMainQuery.isEmpty()) {
            String names = this.refNames(likeMainQuery);
            logger.debug("The following searchable element refs of {} that can be searched with LIKE: {}.", (Object)targetType, (Object)names);
        }
        CqnPredicate like = CdsSearchUtils.searchToLikeExpression(likeMainQuery, (CqnPredicate)search);
        if (navigatesToManyAssoc) {
            like = HanaSearchResolver.pushDownToExistsSubquery(targetType, like, true);
        }
        filter = CQL.or((CqnPredicate)filter, (CqnPredicate)like);
        CdsSearchUtils.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }

    private String refNames(Collection<CqnElementRef> refs) {
        return refs.stream().map(ref -> ref.asValue().displayName()).collect(Collectors.joining(","));
    }

    protected static String toSearchString(CqnPredicate expression) {
        final Stack stack = new Stack();
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnSearchPredicate search) {
                String searchTerm = search.searchTerm();
                if (searchTerm.trim().contains(" ")) {
                    stack.push((Object)("\"*" + searchTerm + "*\""));
                } else {
                    stack.push((Object)("*" + searchTerm + "*"));
                }
            }

            public void visit(CqnConnectivePredicate connective) {
                int n = connective.predicates().size();
                String delimiter = connective.operator() == CqnConnectivePredicate.Operator.AND ? " " : " OR ";
                stack.push((Object)String.join((CharSequence)delimiter, stack.pop(n)));
            }

            public void visit(CqnNegation cqnNegation) {
                stack.push((Object)("-" + (String)stack.pop()));
            }
        };
        expression.accept(visitor);
        if (stack.isEmpty()) {
            throw new IllegalStateException("the search term stack must not be empty!");
        }
        return (String)stack.pop();
    }

    private CqnPredicate searchToHana(Collection<CqnElementRef> searchableRefs, CqnPredicate expression) {
        if (searchableRefs.isEmpty()) {
            return CqnBoolLiteral.FALSE;
        }
        ListValue refs = ListValue.of(searchableRefs);
        return this.searchToHana((CqnListValue)refs, expression);
    }

    protected abstract CqnPredicate searchToHana(CqnListValue var1, CqnPredicate var2);

    protected abstract boolean needsPushToSubquery(CdsElement var1);

    private static class ElementRefComparator
    implements Comparator<CqnElementRef> {
        static final Comparator<CqnElementRef> INSTANCE = new ElementRefComparator();

        private ElementRefComparator() {
        }

        @Override
        public int compare(CqnElementRef ref1, CqnElementRef ref2) {
            int n2;
            List segs1 = ref1.segments();
            List segs2 = ref2.segments();
            int n1 = segs1.size();
            if (n1 > (n2 = segs2.size())) {
                return 1;
            }
            if (n1 < n2) {
                return -1;
            }
            for (int i = 0; i < n1; ++i) {
                String id2;
                String id1 = ((CqnReference.Segment)segs1.get(i)).id();
                int cmp = id1.compareTo(id2 = ((CqnReference.Segment)segs2.get(i)).id());
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

