/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.sqlite;

import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.cqn.CqnLock;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqliteStatementResolver
implements StatementResolver {
    private static final Optional<String> EMPTY = Optional.empty();

    public Optional<String> collate(Locale locale) {
        if (locale != null) {
            return Optional.of("COLLATE NOCASE");
        }
        return EMPTY;
    }

    public String upsert(String table, Stream<String> keyColumns, Stream<String> upsertColumns, Stream<String> upsertValues) {
        List col = upsertColumns.collect(Collectors.toList());
        String columns = SQLHelper.commaSeparated(col.stream());
        String insertValues = SQLHelper.commaSeparated(upsertValues);
        String conflictTarget = SQLHelper.commaSeparated(keyColumns);
        String updateValues = SQLHelper.commaSeparated(col.stream().map(c -> "EXCLUDED." + c));
        return Stream.of("INSERT INTO", table, columns, "VALUES", insertValues, "ON CONFLICT", conflictTarget, "DO UPDATE SET", columns, "=", updateValues).collect(Collectors.joining(" "));
    }

    public Stream<String> lockClause(CqnLock lock) {
        return Stream.empty();
    }
}

