/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class SqlMappingImpl
implements SqlMapping {
    public static final String CDS_PERSISTENCE_NAME = "cds.persistence.name";
    private final CdsStructuredType rowType;
    private final Function<String, String> casing;

    public SqlMappingImpl(CdsStructuredType rowType, Function<String, String> casing) {
        this.rowType = rowType;
        this.casing = casing;
    }

    public String tableName() {
        CdsEntity entity = this.asEntity();
        return this.annotatedName().map(SQLHelper::delimited).orElseGet(() -> this.plainTableName(entity.getQualifiedName()));
    }

    public String localizedViewName() {
        CdsEntity entity = this.asEntity();
        return this.annotatedName().filter(n -> !this.uppercaseOnly((String)n)).map(n -> SQLHelper.delimited(LocaleUtils.localizedEntityName((String)n))).orElseGet(() -> this.plainTableName(LocaleUtils.localizedEntityName((CdsEntity)entity)));
    }

    private boolean uppercaseOnly(String n) {
        return n.equals(n.toUpperCase(Locale.US));
    }

    private CdsEntity asEntity() {
        if (!(this.rowType instanceof CdsEntity)) {
            throw new IllegalStateException(this.rowType.getQualifiedName() + "is no entity");
        }
        return (CdsEntity)this.rowType;
    }

    private Optional<String> annotatedName() {
        return this.rowType.findAnnotation(CDS_PERSISTENCE_NAME).map(CdsAnnotation::getValue);
    }

    public String plainTableName(String qualifiedEntityName) {
        return this.delimitedCasing(qualifiedEntityName.replace(".", "_"));
    }

    public String columnName(String elementName) {
        return this.rowType.findElement(elementName).map(this::columnName).orElseGet(() -> this.delimitedCasing(SqlMappingImpl.underscoreSeparated((CqnElementRef)ElementRefImpl.parse((String)elementName))));
    }

    public String columnName(CqnElementRef ref) {
        return this.columnName(SqlMappingImpl.underscoreSeparated(ref));
    }

    public String columnName(Stream<? extends CqnReference.Segment> segments) {
        return this.columnName(SqlMappingImpl.underscoreSeparated(segments));
    }

    public String columnName(CdsElement element) {
        Optional persistenceName = element.findAnnotation(CDS_PERSISTENCE_NAME);
        if (persistenceName.isPresent()) {
            return SQLHelper.delimited((String)((CdsAnnotation)persistenceName.get()).getValue());
        }
        return this.delimitedCasing(element.getName());
    }

    private static String underscoreSeparated(CqnElementRef ref) {
        return SqlMappingImpl.underscoreSeparated(ref.stream());
    }

    private static String underscoreSeparated(Stream<? extends CqnReference.Segment> segments) {
        return segments.map(CqnReference.Segment::id).collect(Collectors.joining("_"));
    }

    public CdsStructuredType getRowType() {
        return this.rowType;
    }

    public String delimitedCasing(String undelimited) {
        return SQLHelper.delimited(this.casing.apply(undelimited));
    }

    public String columnLikeAlias(CdsElement element) {
        Optional persistenceName = element.findAnnotation(CDS_PERSISTENCE_NAME);
        return persistenceName.map(stringCdsAnnotation -> SQLHelper.delimited((String)stringCdsAnnotation.getValue())).orElseGet(() -> this.casing.apply(element.getName()));
    }

    public String cteName() {
        return this.plainTableName(this.rowType.getQualifiedName().concat(".CTE"));
    }
}

