/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.sqlite;

import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.jdbc.generic.GenericDbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.FunctionMapper;
import com.sap.cds.jdbc.spi.PredicateMapper;
import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.jdbc.sqlite.SqliteBinder;
import com.sap.cds.jdbc.sqlite.SqliteExceptionAnalyzer;
import com.sap.cds.jdbc.sqlite.SqliteFunctionMapper;
import com.sap.cds.jdbc.sqlite.SqliteSessionVariableSetter;
import com.sap.cds.jdbc.sqlite.SqliteStatementResolver;
import java.util.TimeZone;

public final class SqliteDbContext
extends GenericDbContext {
    public SqliteDbContext(DataStoreConfiguration dataStoreConfiguration) {
        super(dataStoreConfiguration);
    }

    @Override
    public FunctionMapper getFunctionMapper() {
        return new SqliteFunctionMapper();
    }

    @Override
    public StatementResolver getStatementResolver() {
        return new SqliteStatementResolver();
    }

    @Override
    public ExceptionAnalyzer getExceptionAnalyzer() {
        return new SqliteExceptionAnalyzer();
    }

    @Override
    public CdsDataStoreConnector.Capabilities getCapabilities() {
        return new CdsDataStoreConnector.Capabilities(){

            public boolean supportsLock() {
                return false;
            }
        };
    }

    @Override
    public PredicateMapper getPredicateMapper() {
        return p -> p;
    }

    @Override
    public SessionVariableSetter getSessionVariableSetter() {
        return new SqliteSessionVariableSetter();
    }

    @Override
    public ValueBinder getBinder(TimeZone timeZone) {
        return new SqliteBinder(timeZone);
    }
}

