/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.search;

import com.sap.cds.CdsData;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.impl.builder.model.MatchPredicate;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.jdbc.generic.AbstractSearchResolver;
import com.sap.cds.jdbc.hana.search.HanaSearchResolverUsingContains;
import com.sap.cds.jdbc.hana.search.HanaSearchResolverUsingScore;
import com.sap.cds.jdbc.spi.SearchResolver;
import com.sap.cds.ql.BooleanValue;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnPassThroughSearchPredicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.ql.cqn.CqnSearchTermPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CdsSearchUtils;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HanaSearchResolver
extends AbstractSearchResolver {
    private static final Logger logger = LoggerFactory.getLogger(HanaSearchResolver.class);
    private static Pattern wildcardPattern = Pattern.compile("(?<!\\\\)[*?]");

    protected HanaSearchResolver(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        super(config, cdsModel, locale);
    }

    public static HanaSearchResolver forLegacyEngine(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        return new HanaSearchResolverUsingContains(config, cdsModel, locale);
    }

    public static SearchResolver forHexEngine(DataStoreConfiguration config, CdsModel cdsModel, Locale locale) {
        return new HanaSearchResolverUsingScore(config, cdsModel, locale);
    }

    protected boolean fuzzySearch() {
        return this.config.getProperty("cds.sql.hana.search.fuzzy", false);
    }

    protected BigDecimal fuzzinessThreshold() {
        return new BigDecimal(this.config.getProperty("cds.sql.hana.search.fuzzinessThreshold", "0.8"));
    }

    @Override
    protected void resolve(CqnSelect select, CqnPredicate search, CdsStructuredType targetType, Collection<CqnElementRef> searchableRefs) {
        TreeSet<CqnElementRef> like = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        TreeMap<CqnElementRef, CdsElement> scoreOrContains = new TreeMap<CqnElementRef, CdsElement>(ElementRefComparator.INSTANCE);
        TreeMap<CqnElementRef, CdsElement> toManyRefs = new TreeMap<CqnElementRef, CdsElement>(ElementRefComparator.INSTANCE);
        boolean languageGiven = this.locale != null;
        boolean pushToSubquery = false;
        for (CqnElementRef ref : searchableRefs) {
            CdsElement element = CdsModelUtils.element((CdsStructuredType)targetType, (CqnElementRef)ref);
            CdsType type = element.getType();
            if (HanaSearchResolver.navigatesToManyAssoc(targetType, ref)) {
                toManyRefs.put(ref, element);
            } else if (type.isSimpleType(CdsBaseType.LARGE_STRING) || type.isSimpleType(CdsBaseType.HANA_CLOB)) {
                this.handleLargeStringElement(like, scoreOrContains, targetType, ref, element);
            } else if (element.isLocalized()) {
                pushToSubquery = this.handleLocalizedElement(targetType, like, scoreOrContains, languageGiven, ref, element);
            } else {
                this.handleRegularElement(targetType, like, scoreOrContains, ref, element);
            }
            pushToSubquery = pushToSubquery || this.needsPushToSubquery(element);
        }
        this.attachSearchExpressionsToStatement(select, search, targetType, scoreOrContains, pushToSubquery, like, toManyRefs);
    }

    protected abstract void handleLargeStringElement(Set<CqnElementRef> var1, Map<CqnElementRef, CdsElement> var2, CdsStructuredType var3, CqnElementRef var4, CdsElement var5);

    protected abstract boolean handleLocalizedElement(CdsStructuredType var1, Set<CqnElementRef> var2, Map<CqnElementRef, CdsElement> var3, boolean var4, CqnElementRef var5, CdsElement var6);

    protected abstract void handleRegularElement(CdsStructuredType var1, Set<CqnElementRef> var2, Map<CqnElementRef, CdsElement> var3, CqnElementRef var4, CdsElement var5);

    protected abstract void handleToManyElements(CdsStructuredType var1, Set<CqnElementRef> var2, Map<CqnElementRef, CdsElement> var3, boolean var4, CqnElementRef var5, CdsElement var6);

    private void attachSearchExpressionsToStatement(CqnSelect select, CqnPredicate search, CdsStructuredType targetType, Map<CqnElementRef, CdsElement> scoreOrContains, boolean pushToSubquery, Set<CqnElementRef> like, Map<CqnElementRef, CdsElement> toManyRefs) {
        CqnBoolLiteral filter = CqnBoolLiteral.FALSE;
        if (!scoreOrContains.isEmpty()) {
            CqnPredicate searchPredicate = this.searchToHana(scoreOrContains, search);
            if (pushToSubquery || !like.isEmpty()) {
                searchPredicate = HanaSearchResolver.pushDownToExistsSubquery(targetType, searchPredicate, true);
            }
            filter = CQL.or((CqnPredicate)filter, (CqnPredicate)searchPredicate);
        }
        if (!like.isEmpty()) {
            if (logger.isDebugEnabled()) {
                String names = this.refNames(like);
                logger.debug("The following searchable element refs of {} that can be searched with LIKE: {}.", (Object)targetType, (Object)names);
            }
            CqnPredicate likePredicate = CdsSearchUtils.searchToLikeExpression(like, (CqnPredicate)search);
            filter = CQL.or((CqnPredicate)filter, (CqnPredicate)likePredicate);
        }
        CdsData tree = CdsData.create();
        for (CqnElementRef toMany : toManyRefs.keySet()) {
            tree.putPath(toMany.path(), (Object)Boolean.TRUE);
        }
        for (Map.Entry entry : tree.entrySet()) {
            Map map = (Map)entry.getValue();
            String assoc = (String)entry.getKey();
            CqnPredicate anyMatch = this.createAnyMatch(targetType.getTargetOf(assoc), search, assoc, map);
            filter = CQL.or((CqnPredicate)filter, (CqnPredicate)anyMatch);
        }
        CdsSearchUtils.moveSearchToWhere((CqnSelect)select, (CqnPredicate)filter);
    }

    private CqnPredicate createAnyMatch(CdsStructuredType targetType, CqnPredicate search, String path, Map<String, Object> map) {
        TreeMap<CqnElementRef, CdsElement> scoreOrContains = new TreeMap<CqnElementRef, CdsElement>(ElementRefComparator.INSTANCE);
        TreeSet<CqnElementRef> like = new TreeSet<CqnElementRef>(ElementRefComparator.INSTANCE);
        BooleanValue filter = CQL.FALSE;
        boolean languageGiven = this.locale != null;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (entry.getValue() == Boolean.TRUE) {
                String elementName = entry.getKey();
                ElementRef ref = CQL.get((String)entry.getKey());
                CdsElement element = targetType.getElement(elementName);
                this.handleToManyElements(targetType, like, scoreOrContains, languageGiven, (CqnElementRef)ref, element);
                continue;
            }
            String assoc = entry.getKey();
            Map nested = (Map)entry.getValue();
            filter = filter.or((CqnPredicate)filter, new CqnPredicate[]{this.createAnyMatch(targetType.getTargetOf(assoc), search, assoc, nested)});
        }
        if (!scoreOrContains.isEmpty()) {
            CqnPredicate searchPredicate = this.searchToHana(scoreOrContains, search);
            filter = filter.or(searchPredicate, new CqnPredicate[0]);
        }
        if (!like.isEmpty()) {
            CqnPredicate likePredicate = CdsSearchUtils.searchToLikeExpression(like, (CqnPredicate)search);
            filter = filter.or(likePredicate, new CqnPredicate[0]);
        }
        return MatchPredicate.any((CqnStructuredTypeRef)CQL.to((String)path).asRef(), (CqnPredicate)filter);
    }

    private String refNames(Collection<CqnElementRef> refs) {
        return refs.stream().map(ref -> ref.asValue().displayName()).collect(Collectors.joining(","));
    }

    protected static SearchString toSearchString(CqnPredicate expression, final boolean fuzzy) {
        final Stack stack = new Stack();
        final boolean[] wildcards = new boolean[]{false};
        final boolean[] raw = new boolean[]{false};
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnSearchTermPredicate search) {
                Object searchTerm = search.searchTerm();
                boolean phrase = ((String)searchTerm).trim().contains(" ");
                boolean wildcardInSearchTerm = wildcardPattern.matcher((CharSequence)searchTerm).find();
                wildcards[0] = wildcards[0] | wildcardInSearchTerm;
                if (!wildcardInSearchTerm && !fuzzy) {
                    searchTerm = "*" + (String)searchTerm + "*";
                }
                if (phrase) {
                    searchTerm = "\"" + (String)searchTerm + "\"";
                }
                stack.push(searchTerm);
            }

            public void visit(CqnPassThroughSearchPredicate search) {
                raw[0] = true;
                stack.push((Object)search.searchString());
            }

            public void visit(CqnConnectivePredicate connective) {
                int n = connective.predicates().size();
                String delimiter = connective.operator() == CqnConnectivePredicate.Operator.AND ? " " : " OR ";
                stack.push((Object)String.join((CharSequence)delimiter, stack.pop(n)));
            }

            public void visit(CqnNegation cqnNegation) {
                stack.push((Object)("-" + (String)stack.pop()));
            }
        };
        expression.accept(visitor);
        if (stack.isEmpty()) {
            throw new IllegalStateException("the search term stack must not be empty!");
        }
        return new SearchString((String)stack.pop(), wildcards[0], raw[0]);
    }

    protected abstract CqnPredicate searchToHana(Map<CqnElementRef, CdsElement> var1, CqnPredicate var2);

    protected abstract boolean needsPushToSubquery(CdsElement var1);

    private static class ElementRefComparator
    implements Comparator<CqnElementRef> {
        static final Comparator<CqnElementRef> INSTANCE = new ElementRefComparator();

        private ElementRefComparator() {
        }

        @Override
        public int compare(CqnElementRef ref1, CqnElementRef ref2) {
            int n2;
            List segs1 = ref1.segments();
            List segs2 = ref2.segments();
            int n1 = segs1.size();
            if (n1 > (n2 = segs2.size())) {
                return 1;
            }
            if (n1 < n2) {
                return -1;
            }
            for (int i = 0; i < n1; ++i) {
                String id2;
                String id1 = ((CqnReference.Segment)segs1.get(i)).id();
                int cmp = id1.compareTo(id2 = ((CqnReference.Segment)segs2.get(i)).id());
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }

    public record SearchString(String searchString, boolean containsWildcards, boolean containsRaw) {
    }
}

