/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsException;
import com.sap.cds.Result;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Cascader;
import com.sap.cds.impl.ConnectedClient;
import com.sap.cds.impl.ConnectedDataStoreConnector;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.CqnValidator;
import com.sap.cds.impl.EntityCascader;
import com.sap.cds.impl.ExceptionHandler;
import com.sap.cds.impl.InlineCountProcessor;
import com.sap.cds.impl.InlineCountProcessorFactory;
import com.sap.cds.impl.JDBCClient;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.impl.TimingLogger;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.CqnParam;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.draft.DraftUtils;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.Upsert;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnFilterableStatement;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnUpsert;
import com.sap.cds.ql.cqn.CqnXsert;
import com.sap.cds.ql.impl.CqnNormalizer;
import com.sap.cds.ql.impl.DeepInsertSplitter;
import com.sap.cds.ql.impl.DeepUpdateSplitter;
import com.sap.cds.ql.impl.DeleteBuilder;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import com.sap.cds.util.OccUtils;
import com.sap.cds.util.PathExpressionResolver;
import com.sap.cds.util.ProjectionProcessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsDataStoreImpl
implements CdsDataStore {
    private static final Logger logger = LoggerFactory.getLogger(CdsDataStoreImpl.class);
    private final CqnValidator cqnValidator;
    private final ConnectedClient connectedClient;
    private final CqnNormalizer cqnNormalizer;
    private final CqnAnalyzer cqnAnalyzer;
    private final DataUtils dataUtils;
    private final Context context;
    private final CdsModel model;
    private final ProjectionProcessor projectionProcessor;
    private final TimingLogger timed;
    private final InlineCountProcessorFactory inlineCountProcessorFactory;
    private final boolean resolveRtViews;

    public CdsDataStoreImpl(Context context, ConnectedDataStoreConnector connector) {
        this.context = context;
        this.model = context.getCdsModel();
        this.connectedClient = connector.create(context);
        this.cqnValidator = CqnValidator.create(context, this.connectedClient.capabilities());
        this.dataUtils = DataUtils.create(context::getSessionContext, (int)context.getDbContext().getCapabilities().timestampPrecision());
        this.connectedClient.setSessionContext(context.getSessionContext());
        this.cqnNormalizer = new CqnNormalizer(context);
        this.cqnAnalyzer = CqnAnalyzer.create((CdsModel)this.model);
        this.projectionProcessor = ProjectionProcessor.create((CdsModel)this.model, (DataUtils)this.dataUtils);
        this.timed = new TimingLogger(logger, context.getDataStoreConfiguration());
        this.inlineCountProcessorFactory = new InlineCountProcessorFactory(this, context.getDataStoreConfiguration());
        this.resolveRtViews = "resolve".equals(context.getDataStoreConfiguration().getProperty("cds.sql.rtview.mode", "resolve"));
    }

    public Result execute(CqnSelect select, Object ... paramValues) {
        return this.execute(select, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnSelect select, Map<String, Object> paramValues) {
        return (Result)this.timed.cqn(() -> this.resolveAndExecuteQuery(select, paramValues), (CqnStatement)select);
    }

    private Result resolveAndExecuteQuery(CqnSelect select, Map<String, Object> paramValues) {
        CqnSelect filteredSelect = (CqnSelect)CqnStatementUtils.addTenantFilter((CqnFilterableStatement)select, (CdsModel)this.model);
        CdsEntity targetEntity = null;
        CdsEntity rowType = null;
        if (filteredSelect.from().isRef()) {
            targetEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)select.from().asRef());
            if (CqnStatementUtils.isSelectStar((List)filteredSelect.items()) && filteredSelect.excluding().isEmpty()) {
                rowType = targetEntity;
            }
        }
        filteredSelect = this.cqnNormalizer.resolveTransformations(filteredSelect);
        if (this.resolveRtView(targetEntity) && select.from().isRef() && select.ref().size() == 1 && (targetEntity == null || !DraftUtils.isActive((CdsStructuredType)targetEntity))) {
            filteredSelect = this.projectionProcessor.resolveRuntimeViews(filteredSelect);
        }
        this.cqnValidator.validate(select, targetEntity);
        try {
            return this.execute(filteredSelect, paramValues, targetEntity, (CdsStructuredType)rowType);
        }
        catch (ExceptionHandler.HanaHexException e) {
            ((Select)((Select)filteredSelect).hint("hdb.NO_USE_HEX_PLAN", (Object)true)).hint("hdb.USE_HEX_PLAN", (Object)false);
            return this.execute(filteredSelect, paramValues, targetEntity, (CdsStructuredType)rowType);
        }
    }

    private boolean resolveRtView(CdsEntity targetEntity) {
        Object rtViewMode;
        if (targetEntity != null && (rtViewMode = targetEntity.getAnnotationValue("@cds.java.rtview.mode", null)) != null) {
            if (rtViewMode instanceof Map) {
                Map map = (Map)rtViewMode;
                rtViewMode = map.get("=");
            }
            return "resolve".equals(rtViewMode);
        }
        return this.resolveRtViews;
    }

    private Result execute(CqnSelect select, Map<String, Object> paramValues, CdsEntity targetEntity, CdsStructuredType rowType) {
        CqnSelect normSelect = this.cqnNormalizer.normalize(select);
        if (rowType == null) {
            rowType = CqnStatementUtils.rowType((CdsModel)this.model, (CqnSelect)normSelect);
        }
        normSelect = this.cqnNormalizer.resolveForwardMappedAssocs(normSelect);
        return this.executeResolvedQuery(normSelect, paramValues).entity(targetEntity).rowType(rowType).result();
    }

    public ResultBuilder executeResolvedQuery(CqnSelect select, Map<String, Object> paramValues) {
        ResultBuilder result;
        InlineCountProcessor inlineCountProcessor = this.inlineCountProcessorFactory.create(select);
        if (CqnStatementUtils.filterIsFalse((CqnSelect)(select = inlineCountProcessor.prepare(select)))) {
            logger.debug("Statement filter condition evaluates to FALSE. Execution skipped.");
            result = ResultBuilder.selectedRows(Collections.emptyList());
        } else {
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)select);
            result = this.connectedClient.executeQuery(pcqn, paramValues, this, select.getLock().isPresent());
        }
        return inlineCountProcessor.execute(result, paramValues);
    }

    public Result execute(CqnSelect select, Iterable<Map<String, Object>> valueSets) {
        return this.execute(select, valueSets, this.connectedClient.getMaxBatchSize());
    }

    public Result execute(CqnSelect select, Iterable<Map<String, Object>> valueSets, int maxBatchSize) {
        int valueSetSize = Iterables.size(valueSets);
        if (valueSetSize == 1) {
            return this.execute(select, valueSets.iterator().next());
        }
        if (!select.orderBy().isEmpty() && valueSetSize > maxBatchSize) {
            throw new UnsupportedOperationException("Order by is not supported when query is executed in multiple batches");
        }
        ArrayList rows = new ArrayList(valueSetSize);
        UnmodifiableIterator partitions = Iterators.partition(valueSets.iterator(), (int)maxBatchSize);
        while (partitions.hasNext()) {
            CqnSelect batchSelect = CqnStatementUtils.batchSelect((CqnSelect)select, (List)((List)partitions.next()));
            List result = this.execute(batchSelect, new Object[0]).list();
            rows.addAll(result);
        }
        return ResultBuilder.selectedRows(rows).result();
    }

    public Result execute(CqnDelete delete, Object ... paramValues) {
        return this.execute(delete, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnDelete delete, Map<String, Object> namedValues) {
        return this.execute(delete, Collections.singletonList(namedValues));
    }

    public Result execute(CqnDelete delete, Iterable<Map<String, Object>> valueSets) {
        CqnDelete filteredDelete = (CqnDelete)CqnStatementUtils.addTenantFilter((CqnFilterableStatement)delete, (CdsModel)this.model);
        filteredDelete = (CqnDelete)this.projectionProcessor.resolve((CqnStatement)filteredDelete);
        CdsEntity target = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)(filteredDelete = this.cqnNormalizer.normalize(filteredDelete)).ref());
        boolean deleted = Cascader.create(CdsModelUtils.CascadeType.DELETE, target).from(filteredDelete.ref()).where(filteredDelete.where()).cascade(path -> this.bulkDelete((CqnDelete)Delete.from((StructuredType)path).hints(delete.hints()), valueSets, true));
        if (deleted) {
            return this.bulkDelete(filteredDelete, valueSets, false);
        }
        target = this.model.getEntity(filteredDelete.ref().firstSegment());
        Set<EntityCascader.EntityKeys> entities = this.cascade(target, filteredDelete.where(), valueSets);
        Result result = this.bulkDelete(filteredDelete, valueSets, false);
        this.delete(entities.stream().map(k -> EntityCascader.EntityOperation.delete(k, null, this.context.getSessionContext())), true, delete.hints());
        return result;
    }

    private Set<EntityCascader.EntityKeys> cascade(CdsEntity target, Optional<CqnPredicate> filter, Iterable<? extends Map<String, Object>> valueSets) {
        EntityCascader cascader = EntityCascader.from(this, target).where(filter);
        Set<EntityCascader.EntityKeys> keySets = valueSets.iterator().hasNext() ? Streams.stream(valueSets).flatMap(v -> cascader.with((Map<String, Object>)v).cascade(CdsModelUtils.CascadeType.DELETE).stream()).collect(Collectors.toSet()) : cascader.cascade(CdsModelUtils.CascadeType.DELETE);
        return keySets;
    }

    private void updateOrInsert(Stream<EntityCascader.EntityOperation> operations, Map<String, Object> hints) {
        List<EntityCascader.EntityOperation> notInDatastore = this.update(operations, hints);
        this.insert(notInDatastore.stream(), hints);
    }

    private void insert(Stream<EntityCascader.EntityOperation> ops, Map<String, Object> hints) {
        ops.collect(Collectors.groupingBy(EntityCascader.EntityOperation::targetEntity)).forEach((entity, data) -> {
            Iterator rows = this.execute((CqnInsert)Insert.into((CdsEntity)entity).entries((Iterable)data).hints(hints)).iterator();
            for (EntityCascader.EntityOperation op : data) {
                op.inserted((Map)rows.next());
            }
        });
    }

    private void groupAndExecute(Stream<EntityCascader.EntityOperation> ops, BiConsumer<CdsEntity, List<EntityCascader.EntityOperation>> action) {
        ops.collect(Collectors.groupingBy(o -> Objects.hash(o.targetEntity().getQualifiedName(), o.updateValues().keySet()))).forEach((g, batch) -> {
            CdsEntity entity = ((EntityCascader.EntityOperation)((Object)((Object)batch.get(0)))).targetEntity();
            action.accept(entity, (List<EntityCascader.EntityOperation>)batch);
        });
    }

    private void upsert(Stream<EntityCascader.EntityOperation> ops, Map<String, Object> hints) {
        this.groupAndExecute(ops, (entity, upserts) -> {
            List entries = upserts.stream().map(EntityCascader.EntityOperation::updateValues).collect(Collectors.toList());
            Result result = this.execute((CqnUpsert)Upsert.into((CdsEntity)entity).entries(entries).hints(hints));
            Iterator resultIter = result.iterator();
            Iterator upsertIter = upserts.iterator();
            for (int i = 0; i < result.batchCount(); ++i) {
                EntityCascader.EntityOperation u = (EntityCascader.EntityOperation)((Object)((Object)upsertIter.next()));
                u.inserted((Map)resultIter.next());
            }
        });
    }

    private List<EntityCascader.EntityOperation> update(Stream<EntityCascader.EntityOperation> ops, Map<String, Object> hints) {
        ArrayList<EntityCascader.EntityOperation> notFound = new ArrayList<EntityCascader.EntityOperation>();
        this.groupAndExecute(ops, (entity, updates) -> {
            List entries = updates.stream().map(EntityCascader.EntityOperation::updateValues).collect(Collectors.toList());
            Result result = this.execute((CqnUpdate)Update.entity((CdsEntity)entity).entries(entries).hints(hints));
            if (result.rowCount() > 0L) {
                Iterator resultIter = result.iterator();
                Iterator updateIter = updates.iterator();
                for (int i = 0; i < result.batchCount(); ++i) {
                    EntityCascader.EntityOperation u = (EntityCascader.EntityOperation)((Object)((Object)updateIter.next()));
                    long rowCount = result.rowCount(i);
                    u.updated((Map)resultIter.next(), rowCount);
                    if (rowCount != 0L) continue;
                    notFound.add(u);
                }
            } else {
                notFound.addAll((Collection<EntityCascader.EntityOperation>)updates);
            }
        });
        return notFound;
    }

    private void delete(Stream<EntityCascader.EntityOperation> ops, boolean rollbackOnFail, Map<String, Object> hints) {
        Collection<List<EntityCascader.EntityOperation>> grouped = CdsDataStoreImpl.groupByEntityAndPath(ops);
        for (List<EntityCascader.EntityOperation> batch : grouped) {
            if (batch.isEmpty()) continue;
            EntityCascader.EntityOperation o = batch.iterator().next();
            Set keyNames = o.targetKeys().keySet();
            StructuredType ref = CQL.entity((String)o.targetEntity().getQualifiedName()).matching(CqnParam.params((Collection)keyNames));
            if (o.path() != null) {
                ref = ref.to(o.path());
            }
            CqnDelete delete = (CqnDelete)DeleteBuilder.from((StructuredType)ref).hints(hints);
            this.bulkDelete(delete, batch, rollbackOnFail);
            batch.forEach(EntityCascader.EntityOperation::deleted);
        }
    }

    private static Collection<List<EntityCascader.EntityOperation>> groupByEntityAndPath(Stream<EntityCascader.EntityOperation> ops) {
        ToLongFunction<String> pathLength = s -> s.chars().filter(c -> c == 46).count();
        Comparator<String> longestPath = Comparator.comparingLong(pathLength).reversed().thenComparing(Function.identity());
        TreeMap grouped = ops.collect(Collectors.groupingBy(o -> o.targetEntity().getQualifiedName() + (String)(o.path() != null ? ":." + o.path() : ""), () -> new TreeMap(longestPath), Collectors.toList()));
        return grouped.values();
    }

    public Result bulkDelete(CqnDelete delete, Iterable<? extends Map<String, Object>> valueSets, boolean rollbackOnFail) {
        CdsEntity target = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)delete.ref());
        this.cqnValidator.validate(delete, target);
        delete = PathExpressionResolver.resolvePath((CqnDelete)delete, (CdsEntity)target);
        CqnDelete projectedDelete = (CqnDelete)this.projectionProcessor.resolve((CqnStatement)delete);
        return (Result)this.timed.cqn(() -> {
            int[] deleteCount;
            if (CqnStatementUtils.filterIsFalse((CqnFilterableStatement)projectedDelete)) {
                logger.debug("Statement filter condition evaluates to FALSE. Execution skipped.");
                int n = (int)StreamSupport.stream(valueSets.spliterator(), false).count();
                deleteCount = new int[n];
            } else {
                PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)projectedDelete);
                ArrayList<Map<String, Object>> parameterValues = new ArrayList<Map<String, Object>>();
                valueSets.forEach(parameterValues::add);
                try {
                    deleteCount = this.connectedClient.executeUpdate(pcqn, parameterValues);
                }
                catch (Exception e) {
                    if (rollbackOnFail) {
                        this.connectedClient.setRollbackOnly();
                    }
                    throw e;
                }
            }
            return ResultBuilder.deletedRows((int[])deleteCount).result();
        }, (CqnStatement)projectedDelete, valueSets.spliterator()::estimateSize);
    }

    public Result execute(CqnInsert insert) {
        insert = this.cqnNormalizer.normalize(insert);
        return this.deepInsert((CqnXsert)insert, false);
    }

    public Result execute(CqnUpsert upsert) {
        if (upsert.entries().isEmpty()) {
            return ResultBuilder.insertedRows(Collections.emptyList()).result();
        }
        upsert = this.cqnNormalizer.normalize(upsert);
        CdsEntity root = this.model.getEntity(upsert.ref().firstSegment());
        CdsEntity target = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)upsert.ref());
        this.dataUtils.enforceTenant((CqnStatement)upsert, root, (Iterable)upsert.entries());
        this.cqnValidator.validate(upsert, target);
        if (DataUtils.isDeep((CdsStructuredType)target, (Collection)upsert.entries()) || !DataUtils.uniformData((CdsStructuredType)target, (Collection)upsert.entries())) {
            return this.deepUpsert(target, upsert).entity(target).result();
        }
        List entries = upsert.entries();
        this.dataUtils.prepareForUpdate((CdsStructuredType)target, entries);
        CqnUpsert resolvedUpsert = (CqnUpsert)this.projectionProcessor.resolve((CqnStatement)((CqnUpsert)CQL.copy((CqnStatement)upsert)));
        return (Result)this.timed.cqn(() -> {
            CdsEntity resolvedEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)resolvedUpsert.ref());
            this.dataUtils.removeVirtualElements((CdsStructuredType)resolvedEntity, resolvedUpsert.entries());
            if (DataUtils.isDeep((CdsStructuredType)resolvedEntity, (Collection)resolvedUpsert.entries())) {
                return this.deepUpsert(target, resolvedUpsert).entity(target).result();
            }
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)resolvedUpsert);
            this.connectedClient.executeUpdate(pcqn, resolvedUpsert.entries());
            return ResultBuilder.insertedRows((List)entries).entity(target).result();
        }, (CqnStatement)resolvedUpsert, entries::size);
    }

    private ResultBuilder deepUpsert(CdsEntity entity, CqnUpsert upsert) {
        Map targetKeys = this.cqnAnalyzer.analyze(upsert.ref()).targetKeyValues();
        DeepUpdateSplitter updateSplitter = new DeepUpdateSplitter(this);
        EntityCascader.EntityOperations operations = updateSplitter.computeOperations(entity, upsert, (Map<String, Object>)targetKeys);
        return this.runOperations(operations, upsert.hints());
    }

    private Result deepInsert(CqnXsert xsert, boolean rollbackOnFail) {
        CdsEntity entity = this.model.getEntity(xsert.ref().firstSegment());
        List entries = xsert.entries();
        int maxBatchSize = JDBCClient.getMaxBatchSize(this.context);
        rollbackOnFail |= xsert.entries().size() > maxBatchSize;
        for (List partition : Lists.partition((List)entries, (int)maxBatchSize)) {
            this.deepInsert(xsert, rollbackOnFail, entity, partition);
        }
        return ResultBuilder.insertedRows((List)entries).entity(entity).result();
    }

    private void deepInsert(CqnXsert xsert, boolean rollbackOnFail, CdsEntity entity, List<Map<String, Object>> entries) {
        this.dataUtils.prepareForInsert((CdsStructuredType)entity, entries);
        this.dataUtils.enforceTenant((CqnStatement)xsert, entity, entries);
        List<Insert> inserts = new DeepInsertSplitter(entity, this.context.getSessionContext(), xsert.hints()).split(entries);
        boolean isRollbackOnly = rollbackOnFail || inserts.size() > 1;
        inserts.forEach(insert -> {
            this.cqnValidator.validate((CqnInsert)insert, CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)insert.ref()));
            CqnInsert projectedInsert = (CqnInsert)this.projectionProcessor.resolve((CqnStatement)insert);
            CdsEntity target = this.model.getEntity(projectedInsert.ref().firstSegment());
            this.dataUtils.removeVirtualElements((CdsStructuredType)target, projectedInsert.entries());
            if (DataUtils.isDeep((CdsStructuredType)target, (Collection)projectedInsert.entries())) {
                this.deepInsert((CqnXsert)projectedInsert, true);
                return;
            }
            this.dataUtils.processOnInsert((CdsStructuredType)target, (Iterable)projectedInsert.entries());
            this.timed.cqn(() -> {
                PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)projectedInsert);
                try {
                    return this.connectedClient.executeUpdate(pcqn, projectedInsert.entries());
                }
                catch (Exception e) {
                    if (isRollbackOnly) {
                        this.connectedClient.setRollbackOnly();
                    }
                    throw e;
                }
            }, (CqnStatement)projectedInsert, projectedInsert.entries()::size);
        });
    }

    public Result execute(CqnUpdate update, Object ... paramValues) {
        return this.execute(update, CdsDataStoreImpl.toIndexMap(paramValues));
    }

    public Result execute(CqnUpdate update, Map<String, Object> namedValues) {
        return this.execute(update, namedValues.isEmpty() ? Collections.emptyList() : Collections.singletonList(namedValues));
    }

    public Result execute(CqnUpdate update, Iterable<Map<String, Object>> valueSets) {
        CdsEntity entity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)update.ref());
        this.cqnValidator.validate(update, entity);
        this.dataUtils.prepareForUpdate((CdsStructuredType)entity, update.entries());
        this.dataUtils.enforceTenant((CqnStatement)update, entity, (Iterable)update.entries());
        if (!CdsDataStoreImpl.hasUpdateData(entity, update)) {
            Result count = this.selectCountAll(entity, update);
            update.entries().forEach(Map::clear);
            return count;
        }
        CqnUpdate resolvedUpdate = update;
        CdsEntity resolvedEntity = entity;
        if (CdsModelUtils.usesRuntimeViews((CdsModel)this.model, (CqnStructuredTypeRef)update.ref())) {
            resolvedUpdate = (CqnUpdate)this.projectionProcessor.resolveProjection((CqnStatement)update);
            resolvedEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)resolvedUpdate.ref());
        }
        if (DataUtils.isDeep((CdsStructuredType)resolvedEntity, (Collection)(resolvedUpdate = this.cqnNormalizer.normalize(resolvedUpdate)).entries()) || !DataUtils.uniformData((CdsStructuredType)resolvedEntity, (Collection)resolvedUpdate.entries())) {
            Map targetKeys = this.cqnAnalyzer.analyze((CqnFilterableStatement)resolvedUpdate).targetKeyValues();
            return this.deepUpdate(resolvedEntity, resolvedUpdate, targetKeys).entity(entity).result();
        }
        CqnUpdate resolved = (CqnUpdate)this.projectionProcessor.resolve((CqnStatement)resolvedUpdate);
        if (resolved != resolvedUpdate) {
            resolvedUpdate = resolved;
            resolvedEntity = CdsModelUtils.entity((CdsModel)this.model, (CqnStructuredTypeRef)resolvedUpdate.ref());
            this.dataUtils.prepareForUpdate((CdsStructuredType)resolvedEntity, resolvedUpdate.entries());
            if (DataUtils.isDeep((CdsStructuredType)resolvedEntity, (Collection)resolvedUpdate.entries())) {
                Map targetKeys = this.cqnAnalyzer.analyze((CqnFilterableStatement)resolvedUpdate).targetKeyValues();
                return this.deepUpdate(resolvedEntity, resolvedUpdate, targetKeys).entity(entity).result();
            }
        }
        this.dataUtils.removeVirtualElements((CdsStructuredType)resolvedEntity, resolvedUpdate.entries());
        if (!CdsDataStoreImpl.hasUpdateData(resolvedEntity, resolvedUpdate)) {
            Result count = this.selectCountAll(resolvedEntity, resolvedUpdate);
            update.entries().forEach(Map::clear);
            return count;
        }
        int[] updateCount = this.flatUpdate(resolvedUpdate, resolvedEntity, valueSets);
        return this.updateResult(update, entity, resolvedUpdate, resolvedEntity, updateCount);
    }

    private Result updateResult(CqnUpdate update, CdsEntity entity, CqnUpdate resolvedUpdate, CdsEntity resolvedEntity, int[] updateCount) {
        List<Map<String, Object>> entries = update.entries();
        if (entries.size() == 1) {
            entries = CdsDataStoreImpl.filledList(updateCount.length, (Map)entries.get(0));
        }
        this.addKeyValuesToEntries(update, entries);
        OccUtils.incrementOrSetEtagValuesVersioned((CdsEntity)resolvedEntity, (CqnUpdate)update, entries, (List)resolvedUpdate.entries());
        return CdsDataStoreImpl.batchUpdateResult(entries, updateCount).entity(entity).result();
    }

    private void addKeyValuesToEntries(CqnUpdate update, List<Map<String, Object>> entries) {
        Map keyValues = this.cqnAnalyzer.analyze((CqnFilterableStatement)update).targetKeyValues();
        if (!keyValues.isEmpty()) {
            entries.forEach(e -> e.putAll(keyValues));
        }
    }

    private static List<Map<String, Object>> filledList(int length, Map<String, Object> entry) {
        ArrayList<Map<String, Object>> entries = new ArrayList<Map<String, Object>>(length);
        for (int i = 0; i < length; ++i) {
            entries.add(entry);
        }
        return entries;
    }

    private static ResultBuilder batchUpdateResult(List<? extends Map<String, Object>> entries, int[] updateCount) {
        return CdsDataStoreImpl.batchUpdateResult(entries, Arrays.stream(updateCount).asLongStream().toArray());
    }

    private static ResultBuilder batchUpdateResult(List<? extends Map<String, Object>> entries, long[] updateCount) {
        ResultBuilder builder = ResultBuilder.batchUpdate();
        builder.addUpdatedRows(updateCount, entries);
        return builder;
    }

    private int[] flatUpdate(CqnUpdate update, CdsEntity entity, Iterable<Map<String, Object>> valueSets) {
        List<Map<String, Object>> parameterValues = CdsDataStoreImpl.mergeParams(update.entries(), valueSets);
        OccUtils.prepareVersionParams((CqnUpdate)update, (CdsEntity)entity, parameterValues, () -> this.context.getSessionContext().getNow());
        if (!DocStoreUtils.targetsDocStore((CdsStructuredType)entity)) {
            CqnStatementUtils.moveKeyValuesToWhere((CdsStructuredType)entity, (CqnUpdate)update, (boolean)true);
        }
        return this.executeTimed(update, valueSets, parameterValues);
    }

    private int[] executeTimed(CqnUpdate update, Iterable<Map<String, Object>> valueSets, List<Map<String, Object>> parameterValues) {
        return (int[])this.timed.cqn(() -> {
            if (CqnStatementUtils.filterIsFalse((CqnFilterableStatement)update)) {
                logger.debug("Statement filter condition evaluates to FALSE. Execution skipped.");
                int n = (int)StreamSupport.stream(valueSets.spliterator(), false).count();
                return new int[n];
            }
            PreparedCqnStatement pcqn = this.connectedClient.prepare((CqnStatement)update);
            return this.connectedClient.executeUpdate(pcqn, parameterValues);
        }, (CqnStatement)update, update.entries()::size);
    }

    private ResultBuilder deepUpdate(CdsEntity entity, CqnUpdate update, Map<String, Object> targetKeys) {
        DeepUpdateSplitter updateSplitter = new DeepUpdateSplitter(this);
        EntityCascader.EntityOperations operations = updateSplitter.computeOperations(entity, update, targetKeys);
        return this.runOperations(operations, update.hints());
    }

    private ResultBuilder runOperations(EntityCascader.EntityOperations operations, Map<String, Object> hints) {
        try {
            this.delete(operations.filter(EntityCascader.EntityOperation.Operation.DELETE), false, hints);
            this.insert(operations.filter(EntityCascader.EntityOperation.Operation.INSERT), hints);
            this.updateOrInsert(operations.filter(EntityCascader.EntityOperation.Operation.UPDATE_OR_INSERT), hints);
            this.upsert(operations.filter(EntityCascader.EntityOperation.Operation.UPSERT), hints);
            this.update(operations.filter(EntityCascader.EntityOperation.Operation.UPDATE), hints);
        }
        catch (Exception e) {
            this.connectedClient.setRollbackOnly();
            throw e;
        }
        if (operations.entries().size() == 1 && operations.updateCount().length > 1) {
            return this.searchedUpdateResult(operations);
        }
        return CdsDataStoreImpl.batchUpdateResult(operations.entries(), operations.updateCount());
    }

    private ResultBuilder searchedUpdateResult(EntityCascader.EntityOperations operations) {
        Map<String, Object> data = operations.entries().get(0);
        return ResultBuilder.updatedRows((long)Arrays.stream(operations.updateCount()).sum(), data);
    }

    private Result selectCountAll(CdsEntity entity, CqnUpdate update) {
        Set keys = CdsModelUtils.concreteKeyNames((CdsStructuredType)entity);
        Select countQuery = CqnStatementUtils.countAll((CqnStatement)update);
        long[] rowCount = new long[update.entries().size()];
        int i = 0;
        for (Map entry : update.entries()) {
            CqnPredicate where = (CqnPredicate)update.where().orElse(CqnBoolLiteral.TRUE);
            where = Conjunction.and((CqnPredicate)where, (CqnPredicate)((CqnPredicate)update.elements().filter(keys::contains).map(key -> CQL.get((String)key).eq((Value)CQL.param((String)key))).collect(Conjunction.and())));
            countQuery.where(where);
            rowCount[i] = ((CqnStatementUtils.Count)this.execute((CqnSelect)countQuery, (Map<String, Object>)entry).single().as(CqnStatementUtils.Count.class)).getCount();
            ++i;
        }
        return CdsDataStoreImpl.batchUpdateResult(CdsDataStoreImpl.filledList(rowCount.length, new HashMap<String, Object>()), rowCount).result();
    }

    private static List<Map<String, Object>> mergeParams(List<Map<String, Object>> updateData, Iterable<Map<String, Object>> valueSets) {
        ArrayList<Map<String, Object>> paramVals = new ArrayList<Map<String, Object>>();
        if (!valueSets.iterator().hasNext()) {
            updateData.forEach(v -> paramVals.add((Map<String, Object>)DataUtils.copyMap((Map)v)));
            return paramVals;
        }
        valueSets.forEach(v -> paramVals.add((Map<String, Object>)DataUtils.copyMap((Map)v)));
        if (updateData.size() == 1) {
            Map<String, Object> data = updateData.get(0);
            paramVals.forEach(p -> p.putAll(data));
            return paramVals;
        }
        if (updateData.size() == paramVals.size()) {
            Iterator<Map<String, Object>> keyIter = updateData.iterator();
            paramVals.forEach(p -> p.putAll((Map)keyIter.next()));
            return paramVals;
        }
        throw new CdsException("Batch update failed: Parameter value list size (" + paramVals.size() + ") does not match batch size (" + updateData.size() + ")");
    }

    private static Map<String, Object> toIndexMap(Object ... paramValues) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        for (int i = 0; i < paramValues.length; ++i) {
            parameters.put(String.valueOf(i), paramValues[i]);
        }
        return parameters;
    }

    private static boolean hasUpdateData(CdsEntity target, CqnUpdate update) {
        return !update.setters().isEmpty() || DataUtils.hasNonKeyValues((CdsStructuredType)target, (Map)update.data());
    }

    public SessionContext getSessionContext() {
        return this.context.getSessionContext();
    }

    public void setSessionContext(SessionContext session) {
        this.context.setSessionContext(session);
        this.connectedClient.setSessionContext(session);
    }

    public void deleteAll(Stream<CdsEntity> entities) {
        this.connectedClient.deleteAll(entities);
    }
}

