/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.Disjunction;
import com.sap.cds.impl.builder.model.ExistsSubquery;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatSelectRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.Ref2Column;
import com.sap.cds.impl.sql.ContainsToLike;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.collate.Collating;
import com.sap.cds.impl.sql.collate.Collator;
import com.sap.cds.impl.util.Stack;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.ql.cqn.CqnArithmeticExpression;
import com.sap.cds.ql.cqn.CqnBetweenPredicate;
import com.sap.cds.ql.cqn.CqnBooleanLiteral;
import com.sap.cds.ql.cqn.CqnCaseExpression;
import com.sap.cds.ql.cqn.CqnComparisonPredicate;
import com.sap.cds.ql.cqn.CqnConnectivePredicate;
import com.sap.cds.ql.cqn.CqnContainmentTest;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExistsSubquery;
import com.sap.cds.ql.cqn.CqnExpression;
import com.sap.cds.ql.cqn.CqnFunc;
import com.sap.cds.ql.cqn.CqnInPredicate;
import com.sap.cds.ql.cqn.CqnInSubquery;
import com.sap.cds.ql.cqn.CqnListValue;
import com.sap.cds.ql.cqn.CqnLiteral;
import com.sap.cds.ql.cqn.CqnNegation;
import com.sap.cds.ql.cqn.CqnNullValue;
import com.sap.cds.ql.cqn.CqnNumericLiteral;
import com.sap.cds.ql.cqn.CqnParameter;
import com.sap.cds.ql.cqn.CqnPlain;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnStringLiteral;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVector;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.cqn.CqnWindowFunc;
import com.sap.cds.ql.impl.CqnNormalizer;
import com.sap.cds.ql.impl.Xpr;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.SessionUtils;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TokenToSQLTransformer
implements Function<CqnToken, String> {
    public static final String SQL_TRUE = "TRUE";
    public static final String SQL_FALSE = "FALSE";
    private static final int SUBSTRING_START_PARAM = 1;
    private final Context context;
    private final List<PreparedCqnStmt.Parameter> params;
    private final Ref2Column aliasResolver;
    private final Deque<QatSelectableNode> outer;
    private final CqnNormalizer cqnNormalizer;
    private final ScalarValueResolver scalarValueResolver;
    private final Collator collator;
    private int parameterPosition = 0;

    public TokenToSQLTransformer(Context context, List<PreparedCqnStmt.Parameter> params, Ref2Column aliasResolver, Deque<QatSelectableNode> outer, Collator collator) {
        this.context = context;
        this.params = params;
        this.aliasResolver = aliasResolver;
        this.outer = outer;
        this.collator = collator;
        this.cqnNormalizer = new CqnNormalizer(context);
        this.scalarValueResolver = context.getDbContext().getScalarValueResolver();
    }

    public static TokenToSQLTransformer notCollating(Context context, List<PreparedCqnStmt.Parameter> params, Ref2Column aliasResolver, Deque<QatSelectableNode> outer) {
        return new TokenToSQLTransformer(context, params, aliasResolver, outer, Collating.OFF);
    }

    public static TokenToSQLTransformer notCollating(Context context, Ref2Column aliasResolver, CdsEntity entity, String tableName, List<PreparedCqnStmt.Parameter> params) {
        return new TokenToSQLTransformer(context, params, aliasResolver, TokenToSQLTransformer.outerQat(entity, tableName), Collating.OFF);
    }

    public static TokenToSQLTransformer notCollating(Context context, Ref2Column aliasResolver, CqnSelect query, CdsStructuredType rowType, List<PreparedCqnStmt.Parameter> params) {
        return new TokenToSQLTransformer(context, params, aliasResolver, TokenToSQLTransformer.outerQat(query, rowType), Collating.OFF);
    }

    private static Deque<QatSelectableNode> outerQat(CdsEntity entity, String tableName) {
        QatEntityRootNode root = new QatEntityRootNode(entity);
        CdsModelUtils.columnsOf((CdsEntity)entity).forEach(e -> root.addChild(new QatElementNode(root, (CdsElement)e)));
        root.setAlias(tableName);
        ArrayDeque<QatSelectableNode> outer = new ArrayDeque<QatSelectableNode>();
        outer.add(root);
        return outer;
    }

    private static Deque<QatSelectableNode> outerQat(CqnSelect query, CdsStructuredType rowType) {
        QatSelectRootNode root = new QatSelectRootNode(query, rowType);
        rowType.elements().forEach(e -> root.addChild(new QatElementNode(root, (CdsElement)e)));
        root.setAlias("SQ");
        ArrayDeque<QatSelectableNode> outer = new ArrayDeque<QatSelectableNode>();
        outer.add(root);
        return outer;
    }

    public String toSQL(CdsStructuredType rowType, CqnPredicate pred) {
        DbContext dbContext = this.context.getDbContext();
        pred = (CqnPredicate)dbContext.getPredicateMapper().apply((Object)pred);
        pred = ContainsToLike.transform(dbContext.getFunctionMapper(), pred);
        if ((pred = CqnStatementUtils.simplifyPredicate((CdsStructuredType)rowType, (CqnPredicate)pred)) == CqnBoolLiteral.TRUE) {
            return null;
        }
        if (pred == CqnBoolLiteral.FALSE) {
            return "1 = 0";
        }
        return this.apply((CqnToken)pred);
    }

    public String toSQL(CqnPredicate pred) {
        return this.toSQL(null, pred);
    }

    public String selectColumn(CqnValue value) {
        value = this.scalarValueResolver.selectListValue(value);
        return this.visit((CqnToken)value, Ref2Column.Clause.SELECT);
    }

    public String orderBy(CqnValue value) {
        return this.visit((CqnToken)value, Ref2Column.Clause.ORDERBY);
    }

    public String sortSpec(CqnSortSpecification sortSpec) {
        return this.visit((CqnToken)sortSpec, Ref2Column.Clause.ORDERBY);
    }

    @Override
    public String apply(CqnToken token) {
        return this.visit(token, Ref2Column.Clause.WHERE);
    }

    private String visit(CqnToken token, Ref2Column.Clause clause) {
        if (token == null) {
            throw new IllegalArgumentException("token must not be null");
        }
        ToSQLVisitor visitor = new ToSQLVisitor(clause);
        token.accept((CqnVisitor)visitor);
        String sql = visitor.get(token);
        if (token instanceof Xpr) {
            sql = sql.substring(1, sql.length() - 1);
        }
        return sql;
    }

    class ToSQLVisitor
    implements CqnVisitor {
        Stack<String> stack = new Stack();
        Ref2Column.Clause clause;

        public ToSQLVisitor(Ref2Column.Clause clause) {
            this.clause = clause;
        }

        public void visit(CqnParameter p) {
            String name = p.isPositional() ? String.valueOf(TokenToSQLTransformer.this.parameterPosition++) : p.name();
            PreparedCqnStmt.Parameter param = new PreparedCqnStmt.CqnParam(name).type(p.type());
            TokenToSQLTransformer.this.params.add(param);
            this.push(TokenToSQLTransformer.this.scalarValueResolver.parameter(p));
        }

        public void visit(CqnFunc cqnFunc) {
            String func = cqnFunc.func().toLowerCase(Locale.US);
            List args = this.stack.pop(cqnFunc.args().size());
            if ("substring".equals(func)) {
                args.set(1, (String)args.get(1) + " + 1");
            }
            this.push(TokenToSQLTransformer.this.context.getDbContext().getFunctionMapper().toSql(func, args));
        }

        public void visit(CqnSortSpecification sortSpec) {
            StringBuilder sort = new StringBuilder((String)this.stack.pop());
            TokenToSQLTransformer.this.collator.collate(sortSpec).ifPresent(cc -> sort.append(" " + cc));
            sort.append(" " + ToSQLVisitor.sortOrderToSql(sortSpec));
            this.stack.push((Object)sort.toString());
        }

        private static String sortOrderToSql(CqnSortSpecification o) {
            return switch (o.order()) {
                case CqnSortSpecification.Order.DESC -> "DESC NULLS LAST";
                case CqnSortSpecification.Order.DESC_NULLS_FIRST -> "DESC NULLS FIRST";
                case CqnSortSpecification.Order.ASC_NULLS_LAST -> "NULLS LAST";
                default -> "NULLS FIRST";
            };
        }

        public void visit(CqnWindowFunc cqnFunc) {
            String func = cqnFunc.func().toLowerCase(Locale.US);
            List orders = this.stack.pop(cqnFunc.window().orderBy().size());
            List partitions = this.stack.pop(cqnFunc.window().partitionBy().size());
            List args = this.stack.pop(cqnFunc.args().size());
            StringBuilder sql = new StringBuilder(TokenToSQLTransformer.this.context.getDbContext().getFunctionMapper().toSql(func, args));
            sql.append(" OVER(");
            CqnWindowFunc.WindowSpecification ov = cqnFunc.window();
            if (!ov.partitionBy().isEmpty()) {
                sql.append("PARTITION BY ");
                sql.append(partitions.stream().collect(Collectors.joining(", ")));
                if (!ov.orderBy().isEmpty()) {
                    sql.append(" ");
                }
            }
            if (!ov.orderBy().isEmpty()) {
                sql.append("ORDER BY ");
                sql.append(orders.stream().collect(Collectors.joining(", ")));
            }
            sql.append(")");
            this.push(sql.toString());
        }

        public void visit(CqnListValue listValue) {
            int n = (int)listValue.values().count();
            String sql = this.stack.pop(n).stream().collect(Collectors.joining(", ", "(", ")"));
            this.push(sql);
        }

        public void visit(CqnContainmentTest test) {
            throw new IllegalStateException("CQN containment test should be transformed to LIKE predicate");
        }

        public void visit(CqnPlain plain) {
            this.push(plain.plain());
        }

        public void visit(CqnBooleanLiteral bool) {
            this.push(TokenToSQLTransformer.this.scalarValueResolver.literal(bool));
        }

        public void visit(CqnNumericLiteral<?> number) {
            Number val = number.value();
            if (number.isConstant()) {
                this.push(String.valueOf(val));
            } else {
                this.pushValueParam((CqnLiteral<?>)number);
            }
        }

        public void visit(CqnStringLiteral literal) {
            if (literal.isConstant()) {
                this.push(SQLHelper.literal((String)literal.value()));
            } else {
                this.pushValueParam((CqnLiteral<?>)literal);
            }
        }

        public void visit(CqnVector vector) {
            TokenToSQLTransformer.this.params.add(new PreparedCqnStmt.ValueParam(() -> ((CqnVector)vector).value()).type(CdsBaseType.VECTOR));
            this.push(TokenToSQLTransformer.this.scalarValueResolver.parameter(vector));
        }

        public void visit(CqnLiteral<?> literal) {
            this.pushValueParam(literal);
        }

        private void pushValueParam(CqnLiteral<?> literal) {
            PreparedCqnStmt.Parameter param = new PreparedCqnStmt.ValueParam(() -> literal.value()).type(literal.type());
            TokenToSQLTransformer.this.params.add(param);
            this.push(TokenToSQLTransformer.this.scalarValueResolver.literal(literal));
        }

        public void visit(CqnNullValue nil) {
            this.push("NULL");
        }

        public void visit(CqnElementRef ref) {
            Optional sParam = SessionUtils.getSessionParameter((CqnElementRef)ref, (SessionContext)TokenToSQLTransformer.this.context.getSessionContext());
            if (sParam.isPresent()) {
                CdsBaseType type = ((SessionUtils.SessionContextVariable)sParam.get()).getType();
                PreparedCqnStmt.Parameter param = new PreparedCqnStmt.ValueParam(((SessionUtils.SessionContextVariable)sParam.get()).getValueSupplier()).type(type);
                TokenToSQLTransformer.this.params.add(param);
                this.push(TokenToSQLTransformer.this.scalarValueResolver.parameter(type));
            } else {
                this.push(((Stream)TokenToSQLTransformer.this.aliasResolver.apply(this.clause, ref)).collect(Collectors.joining(", ")));
            }
        }

        public void visit(CqnExistsSubquery exists) {
            Deque<QatSelectableNode> outerNodes;
            ExistsSubquery subQuery = (ExistsSubquery)exists;
            if (subQuery.getOuter() != null) {
                outerNodes = new ArrayDeque<QatSelectableNode>(TokenToSQLTransformer.this.outer);
                outerNodes.pop();
                outerNodes.add((QatSelectableNode)subQuery.getOuter());
            } else {
                outerNodes = TokenToSQLTransformer.this.outer;
            }
            CqnExistsSubquery normalized = TokenToSQLTransformer.this.cqnNormalizer.normalize(exists);
            SQLStatementBuilder.SQLStatement stmt = SelectStatementBuilder.forSubquery(TokenToSQLTransformer.this.context, TokenToSQLTransformer.this.params, normalized.subquery(), outerNodes).build();
            this.push("EXISTS (" + stmt.sql() + ")");
        }

        public void visit(CqnInSubquery in) {
            String value = (String)this.stack.pop();
            CqnSelect subquery = TokenToSQLTransformer.this.cqnNormalizer.normalize(in.subquery());
            SQLStatementBuilder.SQLStatement stmt = SelectStatementBuilder.forSubquery(TokenToSQLTransformer.this.context, TokenToSQLTransformer.this.params, subquery, TokenToSQLTransformer.this.outer).build();
            this.push(value + " IN (" + stmt.sql() + ")");
        }

        public void visit(CqnExpression xpr) {
            List snippets = this.stack.pop(((Xpr)xpr).size());
            this.push("(" + snippets.stream().collect(SpaceSeparatedCollector.joining()) + ")");
        }

        public void visit(CqnBetweenPredicate between) {
            String high = (String)this.stack.pop();
            String low = (String)this.stack.pop();
            String value = (String)this.stack.pop();
            this.push(value + " between " + low + " and " + high);
        }

        public void visit(CqnArithmeticExpression expr) {
            String right = (String)this.stack.pop();
            String left = (String)this.stack.pop();
            this.push("(" + left + " " + expr.operator().symbol() + " " + right + ")");
        }

        public void visit(CqnCaseExpression expr) {
            int n = expr.cases().size();
            StringBuilder sql = new StringBuilder("CASE");
            String result = (String)this.stack.pop();
            Iterator iter = this.stack.pop(n << 1).iterator();
            while (iter.hasNext()) {
                sql.append(" WHEN ").append((String)iter.next());
                sql.append(" THEN ").append((String)iter.next());
            }
            sql.append(" ELSE ").append(result).append(" END");
            this.push(sql.toString());
        }

        public void visit(CqnComparisonPredicate comparison) {
            String right = (String)this.stack.pop();
            String left = (String)this.stack.pop();
            this.push(left + " " + comparison.operator().symbol + " " + right);
        }

        public void visit(CqnConnectivePredicate connective) {
            String symbol = connective.operator().symbol;
            BiFunction<CqnPredicate, String, String> flattener = connective.operator() == CqnConnectivePredicate.Operator.AND ? this::flatAnd : this::flatOr;
            List original = connective.predicates();
            List snippets = this.stack.pop(original.size());
            StringBuilder sql = new StringBuilder();
            for (int i = 0; i < original.size(); ++i) {
                if (i > 0) {
                    sql.append(" ");
                    sql.append(symbol);
                    sql.append(" ");
                }
                sql.append(flattener.apply((CqnPredicate)original.get(i), (String)snippets.get(i)));
            }
            this.push(sql.toString());
        }

        private String flatAnd(CqnPredicate pred, String snippet) {
            if (pred instanceof Disjunction) {
                return "(" + snippet + ")";
            }
            return snippet;
        }

        String flatOr(CqnPredicate pred, String snippet) {
            return snippet;
        }

        public void visit(CqnInPredicate in) {
            String valueSet = (String)this.stack.pop();
            String value = (String)this.stack.pop();
            this.push(value + " in " + valueSet);
        }

        public void visit(CqnNegation neg) {
            if (neg.predicate() instanceof CqnConnectivePredicate) {
                this.push("not (" + (String)this.stack.pop() + ")");
            } else {
                this.push("not " + (String)this.stack.pop());
            }
        }

        private void push(String snippet) {
            this.stack.push((Object)snippet);
        }

        private String get(CqnToken t) {
            if (this.stack.size() != 1) {
                throw new IllegalStateException("token " + t.toJson() + " can't be mapped");
            }
            return (String)this.stack.pop();
        }
    }
}

