/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.SessionContext;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.reflect.CdsModel;

public abstract class AbstractDataStoreConnector implements CdsDataStoreConnector {

  private final ConnectedDataStoreConnector connector;
  private final CdsModel cdsModel;
  private final DbContext dbContext;
  private final DataStoreConfiguration config;

  protected AbstractDataStoreConnector(
      CdsModel cdsModel,
      ConnectedDataStoreConnector connector,
      DbContext dbContext,
      DataStoreConfiguration config) {
    this.connector = connector;
    this.cdsModel = cdsModel;
    this.dbContext = dbContext;
    this.config = config;
  }

  public DbContext getDbContext() {
    return dbContext;
  }

  @Override
  public CdsDataStore connect() {
    return connect(SessionContext.create());
  }

  @Override
  public CdsModel reflect() {
    return cdsModel;
  }

  @Override
  public CdsDataStore connect(SessionContext session) {
    return new CdsDataStoreImpl(
        ContextImpl.context(cdsModel, dbContext, session, config), connector);
  }

  @Override
  public Capabilities capabilities() {
    return dbContext.getCapabilities();
  }
}
