/*
 * © 2021 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl;

import com.sap.cds.connector.CdsDataStoreConnectorBuilder;
import com.sap.cds.connector.CdsDataStoreConnectorFactory;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.transaction.TransactionManager;

public class CdsDataStoreConnectorFactoryImpl implements CdsDataStoreConnectorFactory {

  @Override
  public CdsDataStoreConnectorBuilder create(
      CdsModel cdsModel, TransactionManager transactionManager) {
    return JDBCDataStoreConnector.create(cdsModel, transactionManager);
  }
}
