/*
 * © 2018-2020 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl;

import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.ql.cqn.CqnStatement;

public interface SQLDataSourceAdapter {

  SQLStatementBuilder.SQLStatement process(CqnStatement statement);

  default String toNative(CqnStatement statement) {
    return process(statement).sql();
  }
}
