/*
 * © 2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl.docstore;

import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.qat.CTE;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class DocStoreCTE implements CTE {
  private static final String $JSON_ALIAS = "\"$JSON\"";

  private final List<PreparedCqnStmt.Parameter> params = new ArrayList<>();
  private final Collection<String> elements;
  private final String tableName;
  private final Context context;
  private final String name;

  public DocStoreCTE(Context context, String tableName, String alias, Collection<String> elements) {
    this.tableName = tableName;
    this.elements = elements;
    this.name = alias;
    this.context = context;
  }

  private String mapElement(String element) {
    if (CqnStatementUtils.$JSON.equals(element)) {
      return tableName + " as " + $JSON_ALIAS;
    }

    String col = SQLHelper.delimited(element);
    String alias = SQLHelper.delimited(context.getDbContext().casing().apply(element));

    return col + " as " + alias;
  }

  @Override
  public String toSQL() {
    return elements.stream()
        .map(this::mapElement)
        .collect(Collectors.joining(", ", name + " as (SELECT ", " FROM " + tableName + ")"));
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public List<PreparedCqnStmt.Parameter> params() {
    return params;
  }
}
