/*
 * © 2018-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsEntity;
import java.util.Optional;

public final class QatAssociation {
  private final CdsEntity targetEntity;
  private final String elementName;
  private final CqnPredicate on;

  QatAssociation(CdsEntity targetEntity, String elementName, CqnPredicate on) {
    this.targetEntity = targetEntity;
    this.elementName = elementName;
    this.on = on;
  }

  public CdsEntity targetEntity() {
    return targetEntity;
  }

  public Optional<CqnPredicate> on() {
    return Optional.ofNullable(on);
  }

  public CqnPredicate onCondition() {
    if (on == null) {
      throw new IllegalStateException("Association '" + elementName + "' has no on-condition.");
    }
    return on;
  }

  public String name() {
    return elementName;
  }
}
