/*
 * © 2018-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl.qat;

import static com.sap.cds.util.CdsTypeUtils.hasJsonType;

import com.sap.cds.reflect.CdsElement;

public final class QatElementNode extends QatNode {

  private final CdsElement element;

  public QatElementNode(QatNode parent, CdsElement element) {
    super(parent);
    this.element = element;
  }

  public CdsElement element() {
    return element;
  }

  @Override
  public String name() {
    return element.getName();
  }

  public boolean isJson() {
    return hasJsonType(element);
  }

  @Override
  public void accept(QatVisitor visitor) {
    visitor.visit(this);
  }

  @Override
  public boolean inSource() {
    return false;
  }
}
