/*
 * © 2020-2021 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.reflect.CdsStructuredType;

public abstract class QatSelectableNode extends QatStructuredNode {

  private volatile String alias; // NOSONAR

  public QatSelectableNode(QatNode parent, CdsStructuredType rowType) {
    super(parent, rowType);
  }

  public void setAlias(String alias) {
    this.alias = alias;
  }

  public String alias() {
    return alias;
  }
}
