/*
 * © 2018-2021 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsStructuredType;

public class QatStructuredElementNode extends QatStructuredNode {

  private final CdsElement element;

  public QatStructuredElementNode(QatNode parent, CdsElement structuredElement) {
    super(parent, structuredElement.getType().as(CdsStructuredType.class));
    this.element = structuredElement;
  }

  @Override
  public String name() {
    return element.getName();
  }

  public CdsElement element() {
    return element;
  }

  @Override
  public boolean inSource() {
    // TODO enable structured types source
    return false;
  }

  @Override
  public void accept(QatVisitor visitor) {
    visitor.visit(this);
  }
}
