/*
 * © 2020-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.reflect.CdsStructuredType;

public final class QatTableFunctionRootNode extends QatSelectableNode {

  private final CqnTableFunction tableFunction;

  public QatTableFunctionRootNode(CqnTableFunction tableFunction, CdsStructuredType rowType) {
    super(null, rowType);
    this.tableFunction = tableFunction;
  }

  public CqnTableFunction tableFunction() {
    return tableFunction;
  }

  @Override
  public void accept(QatVisitor visitor) {
    visitor.visit(this);
  }

  @Override
  public String name() {
    // TODO
    return tableFunction.toJson();
  }

  @Override
  public boolean inSource() {
    return true;
  }
}
