/*
 * © 2018-2019 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.impl.qat;

public class QatTraverser {

  private final QatVisitor visitor;

  private QatTraverser(QatVisitor visitor) {
    this.visitor = visitor;
  }

  public static QatTraverser take(QatVisitor visitor) {
    return new QatTraverser(visitor);
  }

  public void traverse(QatNode qat) {
    qat.accept(visitor);
    qat.children().forEach(this::traverse);
  }
}
