/*
 * © 2024-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.generic;

import com.sap.cds.jdbc.spi.ScalarValueResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnBooleanLiteral;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;

public class GenericScalarValueResolver implements ScalarValueResolver {

  private static final String SQL_TRUE = "TRUE";
  private static final String SQL_FALSE = "FALSE";

  @Override
  public String literal(CqnBooleanLiteral bool) {
    return Boolean.TRUE.equals(bool.value()) ? SQL_TRUE : SQL_FALSE;
  }

  @Override
  public CqnValue selectListValue(CqnValue value) {
    if (!value.isLiteral() && value instanceof CqnPredicate p) {
      value = CQL.copy(p, new UnfoldIsOperatorModifier());
    }
    return value;
  }
}
