/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.hana;

import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import java.util.List;
import java.util.Locale;

public class HanaFunctionMapper extends GenericFunctionMapper {

  @Override
  public String toSql(String cqnFunc, List<String> args) {
    String function = cqnFunc.toLowerCase(Locale.US);
    return switch (function) {
      case "matchespattern" ->
          args.get(0) + " LIKE_REGEXPR " + args.get(1) + " FLAG " + args.get(2);
      case "indexof" -> genericFuncToSql("LOCATE", args) + " - 1";
      default -> super.toSql(cqnFunc, args);
    };
  }
}
