/*
 * © 2023-2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.hana;

import static com.sap.cds.util.CqnStatementUtils.unfold;

import com.sap.cds.jdbc.generic.GenericPredicateMapper;
import com.sap.cds.jdbc.generic.GenericPredicateModifier;
import com.sap.cds.jdbc.generic.UnfoldIsOperatorModifier;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnComparisonPredicate.Operator;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.Modifier;

public class HanaPredicateMapper extends GenericPredicateMapper {

  @Override
  public CqnPredicate apply(CqnPredicate pred) {
    Modifier m =
        new GenericPredicateModifier() {

          @Override
          public CqnPredicate comparison(Value<?> lhs, Operator op, Value<?> rhs) {
            CqnPredicate comp = CQL.comparison(lhs, op, rhs);
            comp =
                switch (op) {
                  case GT, GE, LT, LE, IS, IS_NOT -> unfold(comp);
                  default -> comp;
                };
            return CQL.copy(comp, new UnfoldIsOperatorModifier());
          }
        };

    return CQL.copy(pred, m);
  }
}
