/*
 * © 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.hana.json;

import static com.sap.cds.impl.sql.SQLHelper.delimited;
import static java.util.stream.Collectors.joining;

import com.sap.cds.impl.sql.SqlMappingImpl;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.reflect.CdsStructuredType;
import java.util.function.Function;

public class HanaDocStoreSqlMapping extends SqlMappingImpl {

  public HanaDocStoreSqlMapping(CdsStructuredType rowType, Function<String, String> casing) {
    super(rowType, casing);
  }

  @Override
  public String columnName(CqnElementRef ref) {
    return ref.stream().map(seg -> delimited(seg.id())).collect(joining("."));
  }
}
