/*
 * © 2022 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.hana.search;

import static java.util.stream.Collectors.joining;

import com.sap.cds.ql.cqn.CqnElementRef;
import java.util.Collection;

public class SearchResolverUtils {

  private SearchResolverUtils() {}

  public static String refNames(Collection<CqnElementRef> refs) {
    return refs.stream().map(ref -> ref.displayName()).collect(joining(","));
  }
}
