/*
 * © 2022-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.postgresql;

import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnValue;
import java.util.List;
import java.util.Locale;

public class PostgreSqlFunctionMapper extends GenericFunctionMapper {

  @Override
  public String toSql(String cqnFunc, List<String> args) {
    String function = cqnFunc.toLowerCase(Locale.US);
    return switch (function) {
      case "matchespattern" -> genericFuncToSql("REGEXP_LIKE", args);
      case "indexof" -> genericFuncToSql("STRPOS", args) + " - 1";
      default -> super.toSql(cqnFunc, args);
    };
  }

  @Override
  public Predicate like(CqnValue value, CqnValue pattern, String esc, boolean caseInsensitive) {
    return ilike(value, pattern, esc, caseInsensitive);
  }
}
