/*
 * © 2019-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.sqlite;

import com.sap.cds.jdbc.generic.GenericFunctionMapper;
import java.util.List;
import java.util.Locale;

public class SqliteFunctionMapper extends GenericFunctionMapper {

  @Override
  public String toSql(String cqnFunc, List<String> args) {
    String func = cqnFunc.toLowerCase(Locale.US);
    return switch (func) {
      case "substring" -> genericFuncToSql("substr", args);
      case "trim" -> genericFuncToSql("TRIM", List.of(args.get(0), UNICODE_WHITESPACE_SQL));
      default -> super.toSql(cqnFunc, args);
    };
  }
}
