/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.sqlite;

import com.sap.cds.jdbc.spi.SessionVariableSetter;
import com.sap.cds.jdbc.sqlite.functions.LikeRegexpFunction;
import com.sap.cds.jdbc.sqlite.functions.SessionContextFunction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.sqlite.Function;
import org.sqlite.SQLiteConnection;

public class SqliteSessionVariableSetter implements SessionVariableSetter {

  @Override
  public void set(Connection conn, Map<String, Object> contextVariables) throws SQLException {
    throw new UnsupportedOperationException("SQLite requires updated and old session variables");
  }

  @Override
  public void set(
      Connection conn, Map<String, Object> updatedVariables, Map<String, Object> oldVariables)
      throws SQLException {
    var ctxVars = new HashMap<>(oldVariables);
    ctxVars.putAll(updatedVariables);
    SQLiteConnection sqliteCon = conn.unwrap(SQLiteConnection.class);
    Function.create(sqliteCon, "session_context", new SessionContextFunction(ctxVars));
    Function.create(sqliteCon, "LIKE_REGEX", new LikeRegexpFunction(), 3, 0);
  }
}
