/*
 * © 2023-2025 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.sqlite.functions;

import java.sql.SQLException;
import java.util.regex.Pattern;
import org.sqlite.Function;

/** Emulate SQL standard implementation as LIKE_REGEX(field, pattern, flags). */
public class LikeRegexpFunction extends Function {

  @Override
  protected void xFunc() throws SQLException {
    try {
      String text = value_text(0);
      String pattern = value_text(1);
      String flags = value_text(2);

      // Emulate the way H2 does that. The 'c' is not supported.
      int arguments = Pattern.UNICODE_CASE;
      for (int i = 0; i < flags.length(); i++) {
        switch (flags.charAt(i)) {
          case 'i' -> arguments |= Pattern.CASE_INSENSITIVE;
          case 'm' -> arguments |= Pattern.MULTILINE;
          case 'n' -> arguments |= Pattern.DOTALL;
          default -> throw new IllegalArgumentException("Unsupported flag: " + flags.charAt(i));
        }
      }

      if (text != null) {
        boolean found = Pattern.compile(pattern, arguments).matcher(text).find();
        result(found ? 1 : 0);
      } else {
        result();
      }
    } catch (Exception e) {
      error(e.getMessage());
    }
  }
}
