/*
 * © 2023 SAP SE or an SAP affiliate company. All rights reserved.
 */
package com.sap.cds.jdbc.sqlite.functions;

import static com.sap.cds.jdbc.spi.SessionVariableSetter.APPLICATIONUSER;
import static com.sap.cds.jdbc.spi.SessionVariableSetter.LOCALE;
import static com.sap.cds.jdbc.spi.SessionVariableSetter.TENANT;
import static com.sap.cds.jdbc.spi.SessionVariableSetter.VALID_FROM;
import static com.sap.cds.jdbc.spi.SessionVariableSetter.VALID_TO;

import java.sql.SQLException;
import java.util.Map;
import org.sqlite.Function;

/** Emulate session context function on HANA. */
public class SessionContextFunction extends Function {

  private Map<String, Object> contextVariables;

  public SessionContextFunction(Map<String, Object> contextVariables) {
    this.contextVariables = contextVariables;
  }

  @Override
  protected void xFunc() throws SQLException {
    String sqliteKey = value_text(0);
    String key =
        switch (sqliteKey) {
          case "$user.id" -> APPLICATIONUSER;
          case "$user.locale" -> LOCALE;
          case "$tenant" -> TENANT;
          case "$valid.from", "$at.from" -> VALID_FROM;
          case "$valid.to", "$at.to" -> VALID_TO;
          default -> null;
        };
    Object val = contextVariables.get(key);
    if (val != null) {
      result(val.toString());
    } else {
      result();
    }
  }
}
