/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.DataStoreConfiguration;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.CdsDataStoreImpl;
import com.sap.cds.impl.ConnectedDataStoreConnector;
import com.sap.cds.impl.ContextImpl;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.reflect.CdsModel;

public abstract class AbstractDataStoreConnector
implements CdsDataStoreConnector {
    private final ConnectedDataStoreConnector connector;
    private final CdsModel cdsModel;
    private final DbContext dbContext;
    private final DataStoreConfiguration config;

    protected AbstractDataStoreConnector(CdsModel cdsModel, ConnectedDataStoreConnector connector, DbContext dbContext, DataStoreConfiguration config) {
        this.connector = connector;
        this.cdsModel = cdsModel;
        this.dbContext = dbContext;
        this.config = config;
    }

    public DbContext getDbContext() {
        return this.dbContext;
    }

    public CdsDataStore connect() {
        return this.connect(SessionContext.create());
    }

    public CdsModel reflect() {
        return this.cdsModel;
    }

    public CdsDataStore connect(SessionContext session) {
        return new CdsDataStoreImpl(ContextImpl.context(this.cdsModel, this.dbContext, session, this.config), this.connector);
    }

    public CdsDataStoreConnector.Capabilities capabilities() {
        return this.dbContext.getCapabilities();
    }
}

