/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.qat;

import com.sap.cds.CqnTableFunction;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.draft.DraftUtils;
import com.sap.cds.impl.qat.CTE;
import com.sap.cds.impl.qat.QatAssociation;
import com.sap.cds.impl.qat.QatAssociationNode;
import com.sap.cds.impl.qat.QatElementNode;
import com.sap.cds.impl.qat.QatEntityNode;
import com.sap.cds.impl.qat.QatEntityRootNode;
import com.sap.cds.impl.qat.QatNode;
import com.sap.cds.impl.qat.QatSelectRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.QatStructuredElementNode;
import com.sap.cds.impl.qat.QatStructuredNode;
import com.sap.cds.impl.qat.QatTableFunctionRootNode;
import com.sap.cds.impl.qat.QatTraverser;
import com.sap.cds.impl.qat.QatVisitor;
import com.sap.cds.impl.qat.Ref2Column;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SelectStatementBuilder;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.TableFunctionMapper;
import com.sap.cds.jdbc.spi.TableNameResolver;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class FromClauseBuilder {
    private static final String INNER = "INNER";
    private static final String LEFT = "LEFT";
    private static final String OUTER = "OUTER";
    private static final String JOIN = "JOIN";
    private static final String ON = "ON";
    private static final String LPAREN = "(";
    private static final String RPAREN = ")";
    private static final String AND = "and";
    private final Context context;
    private final List<PreparedCqnStmt.Parameter> params;
    private final Map<String, Object> hints;
    private final Map<String, CTE> ctes;

    public FromClauseBuilder(Context context, List<PreparedCqnStmt.Parameter> params) {
        this(context, params, new HashMap<String, CTE>(), Collections.emptyMap());
    }

    public FromClauseBuilder(Context context, List<PreparedCqnStmt.Parameter> params, Map<String, CTE> ctes, Map<String, Object> hints) {
        this.context = context;
        this.params = params;
        this.hints = hints;
        this.ctes = ctes;
    }

    public Stream<String> sql(Deque<QatSelectableNode> outer) {
        ToSQLVisitor v = new ToSQLVisitor(outer);
        QatTraverser.take(v).traverse(outer.getLast());
        return v.sql();
    }

    private SqlMapping getSqlMapping(CdsStructuredType targetType) {
        return this.context.getDbContext().getSqlMapping(targetType);
    }

    private static EnumSet<DraftUtils.Element> draftElements(QatEntityNode node) {
        final EnumSet<DraftUtils.Element> draftElements = EnumSet.noneOf(DraftUtils.Element.class);
        for (QatNode child : node.children()) {
            child.accept(new QatVisitor(){

                @Override
                public void visit(QatElementNode elementNode) {
                    DraftUtils.draftElement(elementNode.element()).ifPresent(draftElements::add);
                }

                @Override
                public void visit(QatAssociationNode association) {
                    QatAssociation assoc = association.association();
                    assoc.on().ifPresent(o -> o.accept(new CqnVisitor(){

                        public void visit(CqnElementRef ref) {
                            if (ref.size() == 1) {
                                DraftUtils.draftElement(ref.lastSegment()).ifPresent(draftElements::add);
                            }
                        }
                    }));
                }
            });
        }
        return draftElements;
    }

    private static boolean usesLocalizedElements(QatEntityNode node) {
        final CdsEntity entity = node.rowType();
        final boolean[] usesLocalized = new boolean[1];
        final CqnVisitor checkRefs = new CqnVisitor(){

            public void visit(CqnElementRef ref) {
                if (ref.size() == 1 && CdsModelUtils.findElement((CdsStructuredType)entity, (CqnElementRef)ref).map(CdsElementDefinition::isLocalized).orElse(false).booleanValue()) {
                    usesLocalized[0] = true;
                }
            }
        };
        final QatVisitor vElement = new QatVisitor(){

            @Override
            public void visit(QatStructuredElementNode struct) {
                struct.children().forEach(c -> c.accept(this));
            }

            @Override
            public void visit(QatElementNode element) {
                if (element.element().isLocalized()) {
                    usesLocalized[0] = true;
                }
            }

            @Override
            public void visit(QatAssociationNode assoc) {
                assoc.association().on().ifPresent(o -> o.accept(checkRefs));
            }
        };
        QatVisitor vEntity = new QatVisitor(){

            @Override
            public void visit(QatEntityRootNode root) {
                root.filter().ifPresent(f -> f.accept(checkRefs));
                this.checkChildNodes(root);
            }

            @Override
            public void visit(final QatAssociationNode assoc) {
                assoc.filter().ifPresent(f -> f.accept(checkRefs));
                this.checkChildNodes(assoc);
                CqnVisitor collectRefs = new CqnVisitor(){

                    public void visit(CqnElementRef ref) {
                        if (ref.size() == 2 && ref.firstSegment().equals(assoc.name()) && assoc.rowType().findElement(ref.lastSegment()).map(CdsElementDefinition::isLocalized).orElse(false).booleanValue()) {
                            usesLocalized[0] = true;
                        }
                    }
                };
                assoc.association().on().ifPresent(o -> o.accept(collectRefs));
            }

            private void checkChildNodes(QatEntityNode node) {
                Iterator<QatNode> iter = node.children().iterator();
                while (!usesLocalized[0] && iter.hasNext()) {
                    iter.next().accept(vElement);
                }
            }
        };
        node.accept(vEntity);
        return usesLocalized[0];
    }

    private static void checkRef(CqnElementRef ref) {
        if (CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
            throw new IllegalStateException("Can't convert context element ref to column name");
        }
    }

    private class ToSQLVisitor
    implements QatVisitor {
        final Deque<QatSelectableNode> outer;
        final Stream.Builder<String> sql = Stream.builder();

        public ToSQLVisitor(Deque<QatSelectableNode> outer) {
            this.outer = outer;
        }

        @Override
        public void visit(QatEntityRootNode root) {
            this.assertFilterHasNoPaths(root);
            this.table(root);
        }

        @Override
        public void visit(QatSelectRootNode subquery) {
            this.subSelect(subquery.select(), subquery.alias());
        }

        @Override
        public void visit(QatTableFunctionRootNode tableFunction) {
            this.tableFunction(tableFunction.tableFunction(), tableFunction.alias());
        }

        @Override
        public void visit(QatAssociationNode assoc) {
            this.assertFilterHasNoPaths(assoc);
            if (assoc.inSource()) {
                this.add(FromClauseBuilder.INNER);
            } else {
                if (assoc.skipJoin()) {
                    return;
                }
                this.add(FromClauseBuilder.LEFT);
                this.add(FromClauseBuilder.OUTER);
            }
            this.add(FromClauseBuilder.JOIN);
            this.table(assoc);
            this.add(FromClauseBuilder.ON);
            if (assoc.inSource()) {
                this.onConditionFilterOnParent(assoc);
            } else {
                this.onConditionFilterOnTarget(assoc);
            }
        }

        private void assertFilterHasNoPaths(QatEntityNode node) {
            node.filter().ifPresent(f -> f.accept(new CqnVisitor(){

                public void visit(CqnElementRef ref) {
                    if (ref.size() > 1 && !CdsModelUtils.isContextElementRef((CqnElementRef)ref)) {
                        throw new UnsupportedOperationException("Path " + ref + " in infix filter is not supported");
                    }
                }
            }));
        }

        private void onConditionFilterOnParent(QatAssociationNode assoc) {
            this.onCondition(assoc, (QatEntityNode)assoc.parent());
        }

        private void onConditionFilterOnTarget(QatAssociationNode assoc) {
            this.onCondition(assoc, assoc);
        }

        private void onCondition(QatAssociationNode assoc, QatEntityNode filtered) {
            CqnPredicate on = assoc.association().onCondition();
            TokenToSQLTransformer onToSQL = TokenToSQLTransformer.notCollating(FromClauseBuilder.this.context, FromClauseBuilder.this.params, this.refInOnToAlias(assoc), this.outer);
            Optional<CqnPredicate> filter = filtered.filter();
            if (filter.isPresent()) {
                this.add(FromClauseBuilder.LPAREN);
                this.add(onToSQL.toSQL((CdsStructuredType)assoc.entity(), on));
                this.add(FromClauseBuilder.RPAREN);
                TokenToSQLTransformer filterToSQL = TokenToSQLTransformer.notCollating(FromClauseBuilder.this.context, FromClauseBuilder.this.params, this.refInFilterToAlias(filtered), this.outer);
                filter.map(filterToSQL::toSQL).ifPresent(f -> {
                    this.add(FromClauseBuilder.AND);
                    this.add(FromClauseBuilder.LPAREN);
                    this.add((String)f);
                    this.add(FromClauseBuilder.RPAREN);
                });
            } else {
                this.add(onToSQL.toSQL(on));
            }
        }

        private void add(String txt) {
            this.sql.add(txt);
        }

        private Ref2Column refInFilterToAlias(QatEntityNode entityNode) {
            String alias = entityNode.alias();
            CdsEntity entity = entityNode.rowType();
            SqlMapping toSql = FromClauseBuilder.this.getSqlMapping((CdsStructuredType)entity);
            return (clause, ref) -> {
                FromClauseBuilder.checkRef(ref);
                String elementName = ref.lastSegment();
                return Stream.of(alias + "." + toSql.columnName(elementName));
            };
        }

        private Ref2Column refInOnToAlias(QatAssociationNode assoc) {
            String lhs = this.parentAlias(assoc);
            String rhs = assoc.alias();
            CdsStructuredType lhsType = ((QatStructuredNode)assoc.parent()).rowType();
            CdsEntity rhsType = assoc.rowType();
            SqlMapping lhsToSql = FromClauseBuilder.this.getSqlMapping(lhsType);
            SqlMapping rhsToSql = FromClauseBuilder.this.getSqlMapping((CdsStructuredType)rhsType);
            return (clause, ref) -> {
                String columnName;
                String alias;
                FromClauseBuilder.checkRef(ref);
                Stream streamOfSegments = ref.stream();
                if (ref.size() > 1) {
                    streamOfSegments = streamOfSegments.skip(1L);
                }
                if (ref.firstSegment().equals(assoc.name())) {
                    alias = rhs;
                    columnName = rhsToSql.columnName(streamOfSegments);
                } else {
                    alias = lhs;
                    columnName = lhsToSql.columnName(streamOfSegments);
                }
                return Stream.of(alias + "." + columnName);
            };
        }

        private String parentAlias(QatAssociationNode assoc) {
            QatNode parent = assoc.parent();
            if (parent instanceof QatSelectableNode) {
                QatSelectableNode sn = (QatSelectableNode)parent;
                return sn.alias();
            }
            if (parent instanceof QatStructuredElementNode) {
                QatStructuredElementNode sen = (QatStructuredElementNode)parent;
                throw new UnsupportedOperationException("Using association '%s' from structured parent element '%s' is not supported".formatted(assoc.name(), parent.name()));
            }
            throw new IllegalStateException("parent '%s' of association node '%s' has unexpected type %s".formatted(parent.name(), assoc.name(), parent.getClass().getSimpleName()));
        }

        private void subSelect(CqnSelect select, String alias) {
            this.add(FromClauseBuilder.LPAREN);
            SQLStatementBuilder.SQLStatement stmt = SelectStatementBuilder.forSubquery(FromClauseBuilder.this.context, FromClauseBuilder.this.params, select, new ArrayDeque<QatSelectableNode>(), FromClauseBuilder.this.ctes, false).build();
            this.add(stmt.sql());
            this.add(FromClauseBuilder.RPAREN);
            this.add(alias);
        }

        private void tableFunction(CqnTableFunction tableFunction, String alias) {
            TableFunctionMapper mapper = FromClauseBuilder.this.context.getDbContext().getTableFunctionMapper((Object)FromClauseBuilder.this.context, FromClauseBuilder.this.params, tableFunction);
            String fromSQL = mapper.toSQL();
            this.add(fromSQL);
            this.add(alias);
        }

        private String viewName(CdsEntity cdsEntity, EnumSet<DraftUtils.Element> draftElements, boolean usesLocalizedElements) {
            Object tableName = this.tableName(cdsEntity, draftElements, usesLocalizedElements);
            String localParams = cdsEntity.params().map(p -> {
                PreparedCqnStmt.CqnParam param = new PreparedCqnStmt.CqnParam(p.getName(), p.getDefaultValue().orElse(null));
                param.type(((CdsSimpleType)p.getType().as(CdsSimpleType.class)).getType());
                FromClauseBuilder.this.params.add(param);
                return "?";
            }).collect(Collectors.joining(","));
            if (!localParams.isEmpty()) {
                tableName = (String)tableName + FromClauseBuilder.LPAREN + localParams + FromClauseBuilder.RPAREN;
            }
            return tableName;
        }

        private String tableName(CdsEntity cdsEntity, EnumSet<DraftUtils.Element> draftElements, boolean usesLocalizedElements) {
            PlainTableNameResolver resolver = !usesLocalizedElements || this.ignoreLocalizedViews() ? new PlainTableNameResolver() : FromClauseBuilder.this.context.getTableNameResolver();
            if (!this.ignoreDraftSubquery() && DraftUtils.isDraftEnabled((CdsStructuredType)cdsEntity) && !DraftUtils.isDraftView((CdsStructuredType)cdsEntity)) {
                return DraftUtils.activeEntity(FromClauseBuilder.this.context, resolver, cdsEntity, draftElements);
            }
            return resolver.tableName(cdsEntity);
        }

        private boolean ignoreLocalizedViews() {
            return (Boolean)FromClauseBuilder.this.hints.getOrDefault("ignoreLocalizedViews", false);
        }

        private boolean ignoreDraftSubquery() {
            return (Boolean)FromClauseBuilder.this.hints.getOrDefault("ignoreDraftSubqueries", false);
        }

        private void table(QatEntityNode node) {
            if (!FromClauseBuilder.this.ctes.containsKey(node.alias())) {
                CdsEntity entity = node.rowType();
                if (FromClauseBuilder.this.ctes.containsKey(entity.getQualifiedName())) {
                    String cteName = FromClauseBuilder.this.ctes.get(entity.getQualifiedName()).name();
                    if (!this.ignoreDraftSubquery() && DraftUtils.isActive((CdsStructuredType)entity)) {
                        cteName = DraftUtils.activeEntity(FromClauseBuilder.this.context, cteName, entity, FromClauseBuilder.draftElements(node));
                    }
                    this.add(cteName);
                } else {
                    String viewName = this.viewName(entity, FromClauseBuilder.draftElements(node), FromClauseBuilder.usesLocalizedElements(node));
                    this.add(viewName);
                }
            }
            this.add(node.alias());
        }

        private Stream<String> sql() {
            return this.sql.build();
        }
    }

    private class PlainTableNameResolver
    implements TableNameResolver {
        private PlainTableNameResolver() {
        }

        public String tableName(CdsEntity entity) {
            return FromClauseBuilder.this.getSqlMapping((CdsStructuredType)entity).tableName();
        }
    }
}

