/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl.sql;

import com.google.common.collect.Streams;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.qat.CTE;
import com.sap.cds.impl.qat.FromClauseBuilder;
import com.sap.cds.impl.qat.QatBuilder;
import com.sap.cds.impl.qat.QatSelectRootNode;
import com.sap.cds.impl.qat.QatSelectableNode;
import com.sap.cds.impl.qat.Ref2QualifiedColumn;
import com.sap.cds.impl.sql.CommonTableExpression;
import com.sap.cds.impl.sql.SQLHelper;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.impl.sql.SpaceSeparatedCollector;
import com.sap.cds.impl.sql.TokenToSQLTransformer;
import com.sap.cds.impl.sql.collate.Collating;
import com.sap.cds.impl.sql.collate.Collator;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.SqlMapping;
import com.sap.cds.jdbc.spi.StatementResolver;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnLock;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnToken;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public class SelectStatementBuilder
implements SQLStatementBuilder {
    private final Context context;
    private final CqnSelect select;
    private final Deque<QatSelectableNode> outer;
    private final StatementResolver statementResolver;
    private final SessionContext sessionContext;
    private final List<PreparedCqnStmt.Parameter> params;
    private Ref2QualifiedColumn aliasResolver;
    private TokenToSQLTransformer toSQL;
    private final SqlMapping sqlMapping;
    private final FromClauseBuilder fromClauseBuilder;
    private final LocaleUtils localeUtils;
    private final Collator collator;
    private final CdsEntity targetEntity;
    private final boolean isSubquery;
    private final Map<String, CTE> ctes;
    private final boolean withCTEs;

    private SelectStatementBuilder(Context context, List<PreparedCqnStmt.Parameter> params, CqnSelect select, CdsEntity targetEntity, CdsStructuredType sourceType, Deque<QatSelectableNode> outer, Collator collator, boolean isSubquery, Map<String, CTE> ctes, boolean withCTEs) {
        this.context = context;
        this.params = params;
        this.select = select;
        this.outer = SelectStatementBuilder.append(outer, new QatBuilder(context, select, sourceType, outer.size()).create());
        this.statementResolver = context.getDbContext().getStatementResolver();
        this.sessionContext = context.getSessionContext();
        this.ctes = ctes;
        this.withCTEs = withCTEs;
        this.fromClauseBuilder = new FromClauseBuilder(context, params, ctes, select.hints());
        this.localeUtils = new LocaleUtils(context.getCdsModel(), context.getDataStoreConfiguration());
        this.targetEntity = targetEntity;
        this.collator = collator;
        this.sqlMapping = context.getDbContext().getSqlMapping((CdsStructuredType)targetEntity);
        this.isSubquery = isSubquery || outer.peekFirst() instanceof QatSelectRootNode;
    }

    public static SelectStatementBuilder forMainQuery(Context context, List<PreparedCqnStmt.Parameter> params, CqnSelect select) {
        CdsEntity targetEntity = SelectStatementBuilder.target(context, select);
        return new SelectStatementBuilder(context, params, select, targetEntity, SelectStatementBuilder.sourceType(context, select), new ArrayDeque<QatSelectableNode>(), new Collating(context).collatorFor(select, (CdsStructuredType)targetEntity), false, new HashMap<String, CTE>(), true);
    }

    public static SelectStatementBuilder forSubquery(Context context, List<PreparedCqnStmt.Parameter> params, CqnSelect select, Deque<QatSelectableNode> outer, Map<String, CTE> ctes, boolean withCTEs) {
        CdsStructuredType sourceType = SelectStatementBuilder.sourceType(context, select);
        return new SelectStatementBuilder(context, params, select, SelectStatementBuilder.target(context, select), sourceType, outer, Collating.OFF, true, ctes, withCTEs);
    }

    public static SelectStatementBuilder forCTE(Context context, List<PreparedCqnStmt.Parameter> params, CqnSelect select, CdsStructuredType sourceType, Map<String, CTE> ctes) {
        return new SelectStatementBuilder(context, params, select, SelectStatementBuilder.target(context, select), sourceType, new ArrayDeque<QatSelectableNode>(), Collating.OFF, true, ctes, false);
    }

    private static CdsStructuredType sourceType(Context context, CqnSelect select) {
        if (select.from().isRef()) {
            return context.getCdsModel().getEntity(select.from().asRef().firstSegment());
        }
        return CqnStatementUtils.rowType((CdsModel)context.getCdsModel(), (CqnSource)select.from());
    }

    @Override
    public SQLStatementBuilder.SQLStatement build() {
        this.aliasResolver = new Ref2QualifiedColumn(arg_0 -> ((DbContext)this.context.getDbContext()).getSqlMapping(arg_0), this.outer, this.localeUtils);
        this.toSQL = new TokenToSQLTransformer(this.context, this.params, this.aliasResolver, this.outer, this.ctes, false, this.collator);
        CommonTableExpression.collect(this.ctes, this.context, this.outer);
        ArrayList<String> snippets = new ArrayList<String>();
        snippets.add("SELECT");
        this.distinct().forEach(snippets::add);
        if (this.isSubquery) {
            this.columnsSubquery().forEach(snippets::add);
        } else {
            this.columnsMainQuery().forEach(snippets::add);
        }
        this.from().forEach(snippets::add);
        this.where().forEach(snippets::add);
        this.groupBy().forEach(snippets::add);
        this.having().forEach(snippets::add);
        this.orderBy().forEach(snippets::add);
        this.limit().forEach(snippets::add);
        this.lock().forEach(snippets::add);
        this.collator.withCollation().ifPresent(snippets::add);
        if (!this.isSubquery) {
            this.hints().forEach(snippets::add);
        }
        ArrayList<PreparedCqnStmt.Parameter> sqlParams = new ArrayList<PreparedCqnStmt.Parameter>();
        String sql = this.withCTEs(snippets.stream(), sqlParams).collect(SpaceSeparatedCollector.joining());
        return new SQLStatementBuilder.SQLStatement(sql, sqlParams);
    }

    private Stream<String> withCTEs(Stream<String> snippets, List<PreparedCqnStmt.Parameter> sqlParams) {
        if (this.withCTEs) {
            snippets = Stream.concat(CommonTableExpression.with(this.context, this.outer, sqlParams, this.ctes), snippets);
        }
        sqlParams.addAll(this.params);
        return snippets;
    }

    private Stream<String> distinct() {
        if (this.select.isDistinct()) {
            return Stream.of("DISTINCT");
        }
        return Stream.empty();
    }

    private Stream<String> columnsMainQuery() {
        List items = this.select.items();
        if (items.isEmpty()) {
            throw new IllegalStateException("select * not expected");
        }
        Stream.Builder sql = Stream.builder();
        items.stream().flatMap(CqnSelectListItem::ofValue).forEach(slv -> {
            sql.add(",");
            String column = this.toSQL.selectColumn(slv.value());
            sql.add(column);
            slv.alias().ifPresent(a -> sql.add("as").add(SQLHelper.delimited(a)));
        });
        return sql.build().skip(1L);
    }

    private Stream<String> columnsSubquery() {
        List items = this.select.items();
        if (items.isEmpty()) {
            return Stream.of(this.aliasResolver.rootAlias() + ".*");
        }
        HashSet displayNames = new HashSet();
        Stream.Builder sql = Stream.builder();
        items.stream().forEach(sli -> {
            if (sli.isStar()) {
                sql.add(",");
                sql.add(this.aliasResolver.rootAlias() + ".*");
            } else if (sli instanceof CqnSelectListValue) {
                String[] columns;
                CqnSelectListValue slv = (CqnSelectListValue)sli;
                String col = this.toSQL.selectColumn(slv.value());
                if (col.isEmpty()) {
                    return;
                }
                for (String c : columns = col.split(", ")) {
                    ColumnAlias ca = ColumnAlias.of(c, slv);
                    String column = ca.column();
                    Optional alias = ca.alias().flatMap(a -> {
                        String a2 = this.sqlMapping.delimitedCasing(a.replace('.', '_'));
                        return !column.endsWith(a2) ? Optional.of(a2) : Optional.empty();
                    });
                    String displayName = alias.orElse(column);
                    if (!displayNames.add(displayName)) continue;
                    sql.add(",");
                    sql.add(column);
                    alias.ifPresent(a -> sql.add("as").add((String)a));
                }
            }
        });
        return sql.build().skip(1L);
    }

    private Stream<String> from() {
        return Streams.concat((Stream[])new Stream[]{Stream.of("FROM"), this.fromClauseBuilder.sql(this.outer)});
    }

    private Stream<String> where() {
        Optional where = Conjunction.and((Optional)this.select.where(), (Optional)this.select.search());
        CqnSource source = this.select.from();
        if (source.isRef()) {
            CqnStructuredTypeRef ref = source.asRef();
            where = Conjunction.and((Optional)where, (Optional)ref.targetSegment().filter());
        }
        if (this.collator.usesCollate()) {
            Locale locale = this.sessionContext.getLocale();
            this.statementResolver.collate(locale).ifPresent(this.aliasResolver::startCollate);
        }
        Stream.Builder sql = Stream.builder();
        where.map(w -> this.toSQL.toSQL((CdsStructuredType)this.targetEntity, (CqnPredicate)w)).ifPresent(s -> {
            sql.add("WHERE");
            sql.add(s);
        });
        this.aliasResolver.stopCollate();
        return sql.build();
    }

    private Stream<String> groupBy() {
        List groupByTokens = this.select.groupBy();
        if (groupByTokens.isEmpty()) {
            return Stream.empty();
        }
        Stream[] streamArray = new Stream[2];
        streamArray[0] = Stream.of("GROUP BY");
        streamArray[1] = SQLStatementBuilder.commaSeparated(groupByTokens.stream(), this.toSQL::apply);
        return Streams.concat((Stream[])streamArray);
    }

    private Stream<String> having() {
        Optional having = this.select.having();
        if (this.collator.usesCollate()) {
            Locale locale = this.sessionContext.getLocale();
            this.statementResolver.collate(locale).ifPresent(this.aliasResolver::startCollate);
        }
        Stream.Builder sql = Stream.builder();
        having.map(h -> this.toSQL.toSQL((CdsStructuredType)this.targetEntity, (CqnPredicate)h)).ifPresent(s -> {
            sql.add("HAVING");
            sql.add(s);
        });
        this.aliasResolver.stopCollate();
        return sql.build();
    }

    private Stream<String> orderBy() {
        List orderBy = this.select.orderBy();
        if (orderBy.isEmpty()) {
            return Stream.empty();
        }
        Stream[] streamArray = new Stream[2];
        streamArray[0] = Stream.of("ORDER BY");
        streamArray[1] = SQLStatementBuilder.commaSeparated(orderBy.stream(), this.toSQL::sortSpec);
        return Streams.concat((Stream[])streamArray);
    }

    private Stream<String> limit() {
        long top = this.select.top();
        long skip = this.select.skip();
        Stream.Builder<String> sql = Stream.builder();
        if (top < 0L && skip > 0L) {
            top = Integer.MAX_VALUE;
        }
        if (top >= 0L) {
            sql.add("LIMIT");
            sql.add(this.toSQL.apply((CqnToken)CQL.constant((Object)top)));
        }
        if (skip > 0L) {
            sql.add("OFFSET");
            sql.add(this.toSQL.apply((CqnToken)CQL.val((Object)skip)));
        }
        return sql.build();
    }

    private Stream<String> lock() {
        Stream<CqnLock> stream = this.select.getLock().stream();
        return stream.flatMap(arg_0 -> ((StatementResolver)this.statementResolver).lockClause(arg_0));
    }

    private Stream<String> hints() {
        Stream.Builder sql = Stream.builder();
        this.statementResolver.hints(this.select.hints()).ifPresent(sql::add);
        return sql.build();
    }

    private static Deque<QatSelectableNode> append(Deque<QatSelectableNode> prefix, QatSelectableNode newRoot) {
        ArrayDeque<QatSelectableNode> roots = new ArrayDeque<QatSelectableNode>(prefix);
        roots.add(newRoot);
        return roots;
    }

    private static CdsEntity target(Context context, CqnSelect select) {
        return select.from().isRef() ? CdsModelUtils.entity((CdsModel)context.getCdsModel(), (CqnStructuredTypeRef)select.from().asRef()) : null;
    }

    public record ColumnAlias(String column, Optional<String> alias) {
        public static ColumnAlias of(String column, CqnSelectListValue slv) {
            String[] col = column.split("#");
            Optional<String> alias = column.endsWith("#") ? Optional.of(col[1]) : slv.alias();
            return new ColumnAlias(col[0], alias);
        }

        public static String alias(CqnElementRef ref, CqnElementRef fk) {
            return ref.alias().map(a -> "#" + fk.path().replace(fk.firstSegment(), (CharSequence)a) + "#").orElse("");
        }
    }
}

