/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.jdbc.hana.hierarchies;

import com.sap.cds.JSONizable;
import com.sap.cds.impl.parser.token.CqnBoolLiteral;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.ql.Source;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSource;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.ql.hana.HierarchySubset;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElementDefinition;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.reflect.impl.CdsElementBuilder;
import com.sap.cds.reflect.impl.CdsSimpleTypeBuilder;
import com.sap.cds.util.CqnStatementUtils;
import java.util.Optional;

public class HierarchySubsetBuilder
implements HierarchySubset {
    private static final CdsType INTEGER = CdsSimpleTypeBuilder.simpleType((CdsBaseType)CdsBaseType.INT32);
    private static final CdsElementDefinition DISTANCE = CdsElementBuilder.element((String)"hierarchy_distance").type(INTEGER).isNotNull(true).build();
    private final boolean isAncestors;
    protected final Source<?> source;
    protected CqnPredicate startWhere;
    private int from = 0;
    private int to = 0;

    private HierarchySubsetBuilder(Source<?> source, boolean isAncestors) {
        this.source = source;
        this.isAncestors = isAncestors;
        if (isAncestors) {
            this.from = Integer.MIN_VALUE;
        } else {
            this.to = Integer.MAX_VALUE;
        }
    }

    public static HierarchySubsetBuilder ancestors(Source<?> source) {
        return new HierarchySubsetBuilder(source, true);
    }

    public static HierarchySubsetBuilder descendants(Source<?> source) {
        return new HierarchySubsetBuilder(source, false);
    }

    public HierarchySubsetBuilder copy(Source<?> source) {
        HierarchySubsetBuilder impl = new HierarchySubsetBuilder(source, this.isAncestors);
        impl.startWhere = this.startWhere;
        impl.from = this.from;
        impl.to = this.to;
        return impl;
    }

    public HierarchySubsetBuilder startWhere(CqnPredicate startWhere) {
        this.startWhere = startWhere == CqnBoolLiteral.TRUE ? null : startWhere;
        return this;
    }

    public Optional<CqnPredicate> startWhere() {
        return Optional.ofNullable(this.startWhere);
    }

    public int from() {
        return this.from;
    }

    public int to() {
        return this.to;
    }

    public HierarchySubsetBuilder from(int from) {
        this.from = from;
        return this;
    }

    public HierarchySubsetBuilder to(int to) {
        this.to = to;
        return this;
    }

    public HierarchySubsetBuilder distance(int from, int to) {
        this.from = from;
        this.to = to;
        return this;
    }

    public HierarchySubsetBuilder distance(int distanceFromStart, boolean keepStart) {
        if (this.isAncestors) {
            return this.distance(distanceFromStart < 0 ? Integer.MIN_VALUE : -distanceFromStart, keepStart ? 0 : -1);
        }
        return this.distance(keepStart ? 0 : 1, distanceFromStart < 0 ? Integer.MAX_VALUE : distanceFromStart);
    }

    public CqnSource source() {
        return this.source;
    }

    public StructuredType<?> getType() {
        return this.source.getType();
    }

    public void accept(CqnVisitor visitor) {
    }

    public String toJson() {
        Jsonizer cqn = Jsonizer.object((String)"source", this.source);
        if (this.startWhere != null) {
            cqn.put("startWhere", (Object)this.startWhere);
        }
        if (this.from > Integer.MIN_VALUE && this.from < Integer.MAX_VALUE) {
            cqn.put("from", (Object)this.from);
        }
        if (this.to > Integer.MIN_VALUE && this.to < Integer.MAX_VALUE) {
            cqn.put("to", (Object)this.to);
        }
        String subset = this.isAncestors ? "ancestors" : "descendants";
        return Jsonizer.object((String)subset, (JSONizable)cqn).toJson();
    }

    public boolean isAncestors() {
        return this.isAncestors;
    }

    public boolean isDescendants() {
        return !this.isAncestors;
    }

    public CdsStructuredType rowType(CdsStructuredType sourceRowType) {
        return CqnStatementUtils.addElementsTo((CdsStructuredType)sourceRowType, (CdsElementDefinition[])new CdsElementDefinition[]{DISTANCE});
    }

    public String name() {
        return this.isAncestors ? "HIERARCHY_ANCESTORS" : "HIERARCHY_DESCENDANTS";
    }
}

