/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.impl;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.CdsDataStore;
import com.sap.cds.CdsDataStoreConnector;
import com.sap.cds.CdsDataStoreException;
import com.sap.cds.CdsException;
import com.sap.cds.CdsLockTimeoutException;
import com.sap.cds.ResultBuilder;
import com.sap.cds.SessionContext;
import com.sap.cds.impl.AssociationLoader;
import com.sap.cds.impl.ConnectedClient;
import com.sap.cds.impl.Context;
import com.sap.cds.impl.ContextImpl;
import com.sap.cds.impl.ExceptionHandler;
import com.sap.cds.impl.JdbcDataSourceAdapter;
import com.sap.cds.impl.PreparedCqnStatement;
import com.sap.cds.impl.PreparedCqnStmt;
import com.sap.cds.impl.SQLDataSourceAdapter;
import com.sap.cds.impl.TimingLogger;
import com.sap.cds.impl.docstore.DocStoreUtils;
import com.sap.cds.impl.localized.LocaleUtils;
import com.sap.cds.impl.parser.JsonParser;
import com.sap.cds.impl.parser.token.Jsonizer;
import com.sap.cds.impl.sql.SQLStatementBuilder;
import com.sap.cds.jdbc.spi.DbContext;
import com.sap.cds.jdbc.spi.ExceptionAnalyzer;
import com.sap.cds.jdbc.spi.ValueBinder;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnExpand;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.impl.ExpandProcessor;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.transaction.TransactionManager;
import com.sap.cds.transaction.TransactionRequiredException;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.CqnStatementUtils;
import com.sap.cds.util.DataUtils;
import java.io.Reader;
import java.lang.reflect.UndeclaredThrowableException;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCClient
implements ConnectedClient {
    private static final Logger logger = LoggerFactory.getLogger(JDBCClient.class);
    private static final TimingLogger timed = new TimingLogger(logger, false);
    private static final Object INITIAL = new Object();
    private final Supplier<SQLDataSourceAdapter> adapter;
    private final TransactionManager transactionManager;
    private final Supplier<Connection> ds;
    private final ValueBinder binder;
    private final ExceptionAnalyzer exceptionAnalyzer;
    private final CdsDataStoreConnector.Capabilities capabilities;
    private final Map<String, Object> oldSessionVars = new HashMap<String, Object>();
    private Context context;
    private int maxBatchSize;

    public JDBCClient(Context context, Supplier<Connection> ds, TransactionManager transactionManager) {
        this.context = context;
        this.ds = ds;
        this.transactionManager = transactionManager;
        DbContext dbContext = context.getDbContext();
        this.binder = dbContext.getBinder(context.getSessionContext().getTimeZone());
        this.adapter = () -> new JdbcDataSourceAdapter(this.context);
        this.exceptionAnalyzer = context.getDbContext().getExceptionAnalyzer();
        this.capabilities = context.getDbContext().getCapabilities();
        this.maxBatchSize = JDBCClient.getMaxBatchSize(context);
    }

    @Override
    public PreparedCqnStatement prepare(CqnStatement statement) {
        if (statement.isSelect()) {
            return this.prepare(statement.asSelect());
        }
        SQLStatementBuilder.SQLStatement stmt = this.adapter.get().process(statement);
        CdsEntity root = CdsModelUtils.entity((CdsModel)this.context.getCdsModel(), (CqnStructuredTypeRef)statement.ref());
        CqnStructuredTypeRef ref = null;
        try {
            ref = statement.ref();
        }
        catch (CdsException cdsException) {
            // empty catch block
        }
        return PreparedCqnStmt.createUpdate(stmt.sql(), stmt.params(), ref, root);
    }

    public PreparedCqnStmt prepare(CqnSelect select) {
        CdsStructuredType targetType = CqnStatementUtils.targetType((CdsModel)this.context.getCdsModel(), (CqnSelect)select);
        CqnStructuredTypeRef ref = null;
        if (!CqnStatementUtils.containsPathExpression((Optional)select.where())) {
            ref = CqnStatementUtils.targetRef((CqnSelect)select);
        }
        return this.prepare(select, ref, targetType);
    }

    private PreparedCqnStmt prepare(CqnSelect select, CqnStructuredTypeRef ref, CdsStructuredType targetType) {
        List<ExpandProcessor> expandProcessors = JDBCClient.prepareExpands(select, this.context.getCdsModel(), targetType, ref);
        SQLStatementBuilder.SQLStatement stmt = this.adapter.get().process((CqnStatement)select);
        return PreparedCqnStmt.create(stmt.sql(), select.items(), expandProcessors, select.excluding(), stmt.params(), ref, targetType);
    }

    private static List<ExpandProcessor> prepareExpands(CqnSelect select, CdsModel model, CdsStructuredType targetType, CqnStructuredTypeRef ref) {
        if (DocStoreUtils.targetsDocStore(targetType)) {
            return Collections.emptyList();
        }
        List expands = CqnStatementUtils.removeExpands((CqnSelect)select);
        ArrayList<ExpandProcessor> expandProcessors = new ArrayList<ExpandProcessor>(expands.size());
        if (!expands.isEmpty()) {
            boolean addMissingKeys = !select.isDistinct() && CqnStatementUtils.isNoAggregation((CqnSelect)select);
            boolean optimizeToManyExpands = addMissingKeys && ref != null;
            Map keyAliases = CqnStatementUtils.selectedKeys((CqnSelect)select, (CdsStructuredType)targetType, (boolean)addMissingKeys);
            for (CqnExpand expand : expands) {
                if (CdsModelUtils.isVirtualEntity((CdsModel)model, (CdsEntity)CdsModelUtils.entity((CdsStructuredType)targetType, (List)expand.ref().segments()))) continue;
                ExpandProcessor expandProcessor = ExpandProcessor.create(select, model, ref, targetType, keyAliases, expand, optimizeToManyExpands);
                expandProcessor.addMappingKeys(select);
                expandProcessors.add(expandProcessor);
            }
        }
        return expandProcessors;
    }

    private static int append(int[] arr, int[] elements, int pos) {
        System.arraycopy(elements, 0, arr, pos, elements.length);
        return pos + elements.length;
    }

    private static void rejectAutoCommit(Connection conn) throws SQLException {
        if (conn.getAutoCommit()) {
            throw new TransactionRequiredException("Connection must not be in auto-commit mode");
        }
    }

    @Override
    public ResultBuilder executeQuery(PreparedCqnStatement preparedStmt, Map<String, Object> paramValues, CdsDataStore dataStore, boolean isTransactionRequired) {
        PreparedCqnStmt stmt;
        if (isTransactionRequired) {
            this.requireTransaction();
        }
        if ((stmt = (PreparedCqnStmt)preparedStmt) != null) {
            try {
                List<Map<String, Object>> rows = this.executeQuery(stmt, paramValues);
                if (!rows.isEmpty()) {
                    this.executeExpands(stmt.expands(), paramValues, dataStore, (CdsStructuredType)stmt.targetType(), rows);
                    List<String> excluding = stmt.excluding();
                    if (!excluding.isEmpty()) {
                        rows.forEach(row -> row.keySet().removeAll(excluding));
                    }
                }
                return ResultBuilder.selectedRows(rows);
            }
            catch (SQLException ex) {
                ExceptionHandler.chainNextExceptions(ex);
                if (this.exceptionAnalyzer.isLockTimeout(ex)) {
                    throw new CdsLockTimeoutException(stmt.targetType());
                }
                throw ExceptionHandler.dataStoreException(ex, stmt.toNative());
            }
        }
        throw new IllegalStateException("PreparedCqnStatement must not be null");
    }

    private List<Map<String, Object>> executeQuery(PreparedCqnStmt pcqn, Map<String, Object> paramValues) throws SQLException {
        List list;
        block9: {
            String sql = pcqn.toNative();
            List<PreparedCqnStmt.Parameter> params = pcqn.parameters();
            ValueBinder.Setter[] setters = this.createSetters(params);
            Connection conn = this.ds.get();
            try {
                list = (List)timed.sql(() -> {
                    this.establishSessionVariables(conn);
                    try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                        List<Map<String, Object>> list;
                        block12: {
                            this.bindValues(pstmt, paramValues, params, setters, (CdsStructuredType)pcqn.targetType());
                            ResultSet rs = pstmt.executeQuery();
                            try {
                                list = this.result(pcqn, rs);
                                if (rs == null) break block12;
                            }
                            catch (Throwable throwable) {
                                if (rs != null) {
                                    try {
                                        rs.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            rs.close();
                        }
                        return list;
                    }
                }, sql, List::size);
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UndeclaredThrowableException ex) {
                    Throwable rootCause = ExceptionAnalyzer.getRootCause((Throwable)ex);
                    if (rootCause instanceof SQLException) {
                        SQLException e = (SQLException)rootCause;
                        throw e;
                    }
                    throw ExceptionHandler.dataStoreException(ex, sql);
                }
            }
            conn.close();
        }
        return list;
    }

    private void executeExpands(List<ExpandProcessor> expands, Map<String, Object> paramValues, CdsDataStore dataStore, CdsStructuredType targetType, List<Map<String, Object>> rows) {
        AssociationLoader assocLoader = new AssociationLoader(dataStore, this.context.getDbContext(), targetType);
        for (ExpandProcessor expandProcessor : expands) {
            if (expandProcessor.isPathExpand()) {
                expandProcessor.expand(rows, dataStore, paramValues);
                if (!expandProcessor.hasCountAndLimit()) continue;
                expandProcessor.inlineCount(rows, dataStore, paramValues);
                continue;
            }
            assocLoader.expand(expandProcessor, rows);
        }
    }

    @Override
    public int[] executeUpdate(PreparedCqnStatement preparedStmt, List<Map<String, Object>> parameterValues) {
        int[] nArray;
        block9: {
            PreparedCqnStmt pcqn = (PreparedCqnStmt)preparedStmt;
            this.requireTransaction();
            String sql = pcqn.toNative();
            CdsEntity entity = (CdsEntity)pcqn.targetType();
            Connection conn = this.ds.get();
            try {
                nArray = (int[])timed.sql(() -> {
                    JDBCClient.rejectAutoCommit(conn);
                    this.establishSessionVariables(conn);
                    try (PreparedStatement pstmt = conn.prepareStatement(sql);){
                        List<PreparedCqnStmt.Parameter> params = pcqn.parameters();
                        if (parameterValues.size() > 1) {
                            int[] nArray = this.executeBatch(sql, pstmt, params, parameterValues, entity);
                            return nArray;
                        }
                        Map<String, Object> values = this.firstEntry(parameterValues);
                        ValueBinder.Setter[] setters = this.createSetters(params);
                        this.bindValues(pstmt, values, params, setters, (CdsStructuredType)entity);
                        int[] nArray = new int[]{pstmt.executeUpdate()};
                        return nArray;
                    }
                }, sql, rc -> Arrays.stream(rc).sum());
                if (conn == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (CdsException e) {
                    throw e;
                }
                catch (Exception e) {
                    ExceptionHandler exHandler = new ExceptionHandler(entity, this.exceptionAnalyzer);
                    throw exHandler.cdsException(this.firstEntry(parameterValues), e, sql);
                }
            }
            conn.close();
        }
        return nArray;
    }

    private int[] executeBatch(String sql, PreparedStatement pstmt, List<PreparedCqnStmt.Parameter> params, List<Map<String, Object>> entries, CdsEntity entity) throws SQLException {
        int row = 0;
        int rcPosition = 0;
        int[] result = new int[entries.size()];
        try {
            ValueBinder.Setter[] setters = this.createSetters(params);
            for (Map<String, Object> entry : entries) {
                this.bindValues(pstmt, entry, params, setters, (CdsStructuredType)entity);
                pstmt.addBatch();
                if (++row % this.maxBatchSize != 0) continue;
                int[] rc = pstmt.executeBatch();
                rcPosition = JDBCClient.append(result, rc, rcPosition);
            }
            int[] rc = pstmt.executeBatch();
            rcPosition = JDBCClient.append(result, rc, rcPosition);
            return result;
        }
        catch (BatchUpdateException ex) {
            ExceptionHandler.chainNextExceptions(ex);
            throw new ExceptionHandler(entity, this.exceptionAnalyzer).cdsBatchException(entries, rcPosition, ex, sql);
        }
    }

    private ValueBinder.Setter[] createSetters(List<PreparedCqnStmt.Parameter> params) {
        int size = params.size();
        ValueBinder.Setter[] setters = new ValueBinder.Setter[size + 1];
        for (int col = 1; col <= size; ++col) {
            PreparedCqnStmt.Parameter param = params.get(col - 1);
            ValueBinder.Setter setter = this.binder.setter(param.type());
            setters[col] = (arg_0, arg_1, arg_2) -> ((ValueBinder.Setter)setter).set(arg_0, arg_1, arg_2);
        }
        return setters;
    }

    private void requireTransaction() {
        if (!this.transactionManager.isActive()) {
            throw new TransactionRequiredException();
        }
    }

    private void bindValues(PreparedStatement pstmt, Map<String, Object> values, List<PreparedCqnStmt.Parameter> params, ValueBinder.Setter[] binders, CdsStructuredType entity) throws SQLException {
        for (int col = 1; col <= params.size(); ++col) {
            PreparedCqnStmt.Parameter param = params.get(col - 1);
            Object value = param.get(values);
            if (value != null && Collection.class.isAssignableFrom(value.getClass())) {
                value = Jsonizer.json((Object)value);
            }
            try {
                binders[col].set(pstmt, col, value);
                continue;
            }
            catch (IllegalArgumentException | NullPointerException e) {
                throw new CdsDataException("Invalid value for '" + entity + "." + param.name() + "' of type " + param.type(), (Throwable)e);
            }
        }
    }

    private List<Map<String, Object>> result(PreparedCqnStmt pcqn, ResultSet dbResult) throws SQLException {
        Object targetType = pcqn.targetType();
        int columnCount = dbResult.getMetaData().getColumnCount();
        List<CqnSelectListValue> selectValues = pcqn.selectListItems().stream().flatMap(CqnSelectListItem::ofValue).toList();
        ColumnHandler[] columnHandlers = this.columnHandlers((CdsStructuredType)targetType, selectValues, columnCount);
        try {
            ArrayList<Map<String, Object>> rows = new ArrayList<Map<String, Object>>();
            while (dbResult.next()) {
                rows.add(this.extractData(dbResult, selectValues, columnHandlers));
            }
            return rows;
        }
        catch (SQLException e) {
            ExceptionHandler.chainNextExceptions(e);
            throw new CdsDataStoreException("Failed to process result set", (Throwable)e);
        }
    }

    private ColumnHandler[] columnHandlers(CdsStructuredType targetType, List<CqnSelectListValue> selectList, int columnCount) {
        ColumnHandler[] columnHandlers = new ColumnHandler[columnCount];
        for (int i = 0; i < columnCount; ++i) {
            CqnSelectListValue slv = selectList.get(i);
            String displayName = slv.displayName();
            columnHandlers[i] = this.createHandler(targetType, slv, displayName);
        }
        return columnHandlers;
    }

    private ColumnHandler createHandler(CdsStructuredType targetType, CqnSelectListValue slv, String displayName) {
        if (displayName.endsWith("$json")) {
            ValueBinder.Getter typeMapper = this.binder.getter(CdsBaseType.LARGE_STRING, true);
            ValueBinder.Getter valueExtractor = (result, col) -> {
                Reader reader = (Reader)typeMapper.get(result, col);
                if (reader == null) {
                    return Collections.emptyMap();
                }
                return JsonParser.map((Reader)reader);
            };
            String prefix = displayName.substring(0, displayName.lastIndexOf("$json"));
            return new ColumnHandler(prefix, (ValueBinder.Getter<Object>)valueExtractor);
        }
        ValueBinder.Getter valueExtractor = this.binder.getter(targetType, slv);
        return new ColumnHandler(displayName, (ValueBinder.Getter<Object>)valueExtractor);
    }

    private Map<String, Object> extractData(ResultSet result, List<CqnSelectListValue> selectList, ColumnHandler[] columnHandlers) throws SQLException {
        HashMap<String, Object> row = new HashMap<String, Object>(selectList.size());
        for (int i = 1; i <= columnHandlers.length; ++i) {
            ColumnHandler column = columnHandlers[i - 1];
            Object value = column.valueExtractor.get(result, i);
            CqnSelectListValue slv = selectList.get(i - 1);
            if (value instanceof Map && slv.ofRef().anyMatch(r -> r.lastSegment().equals("$json"))) {
                this.mergeObject(row, slv, (Map)value, column.displayName);
                continue;
            }
            if (column.hidden) {
                DataUtils.createPath(row, (String)column.displayName, (value != null ? 1 : 0) != 0);
                continue;
            }
            if (column.structuringAlias) {
                DataUtils.resolvePathAndAdd(row, (String)column.displayName, (Object)value);
                continue;
            }
            row.put(column.displayName, value);
        }
        return row;
    }

    private void mergeObject(Map<String, Object> data, CqnSelectListValue slv, Map<String, Object> mapValue, String displayName) {
        CqnElementRef jsonRef = slv.asRef();
        mapValue.forEach((k, v) -> {
            ElementRef innerRef = CQL.to(jsonRef.segments().subList(0, jsonRef.segments().size() - 1)).get(k);
            ElementRef innerSlv = innerRef.as(displayName + k);
            DataUtils.resolvePathAndAdd((Map)data, (String)innerSlv.displayName(), (Object)v);
        });
    }

    private Map<String, Object> firstEntry(List<Map<String, Object>> valueList) {
        return valueList.isEmpty() ? Collections.emptyMap() : valueList.get(0);
    }

    @Override
    public void setSessionContext(SessionContext session) {
        this.context = ContextImpl.context(this.context.getCdsModel(), this.context.getDbContext(), session, this.context.getDataStoreConfiguration());
        this.maxBatchSize = JDBCClient.getMaxBatchSize(this.context);
        if (this.transactionManager.isActive()) {
            try (Connection conn = this.ds.get();){
                this.establishSessionVariables(conn);
            }
            catch (SQLException e) {
                throw new CdsDataStoreException("Failed to eagerly set context variables on transaction", (Throwable)e);
            }
        }
    }

    @VisibleForTesting
    void establishSessionVariables(Connection conn) {
        SessionContext session = this.context.getSessionContext();
        boolean txIsActive = this.transactionManager.isActive();
        ContextVars contextVars = new ContextVars(session, !txIsActive);
        contextVars.putIfRequired("LOCALE", s -> LocaleUtils.getLocaleString((Locale)s.getLocale()));
        contextVars.putIfRequired("VALID-FROM", s -> s.getValidFrom());
        contextVars.putIfRequired("VALID-TO", s -> s.getValidTo());
        contextVars.putIfRequired("APPLICATIONUSER", s -> s.getUserContext() != null ? s.getUserContext().getId() : null);
        contextVars.putIfRequired("TENANT", s -> s.getUserContext() != null ? s.getUserContext().getTenant() : null);
        if (!contextVars.isEmpty()) {
            Map<String, Object> vars = contextVars.get();
            try {
                this.context.getDbContext().getSessionVariableSetter().set(conn, vars, this.oldSessionVars);
                if (txIsActive) {
                    this.oldSessionVars.putAll(vars);
                }
            }
            catch (SQLException e) {
                throw new CdsDataStoreException("Failed to set context variables %s".formatted(vars), (Throwable)e);
            }
        }
    }

    @Override
    public int getMaxBatchSize() {
        return JDBCClient.getMaxBatchSize(this.context);
    }

    public static int getMaxBatchSize(Context context) {
        return Math.max(1, context.getDataStoreConfiguration().getProperty("cds.sql.max-batch-size", 1000));
    }

    @Override
    public CdsDataStoreConnector.Capabilities capabilities() {
        return this.capabilities;
    }

    @Override
    public void setRollbackOnly() {
        this.transactionManager.setRollbackOnly();
    }

    @Override
    public void deleteAll(Stream<CdsEntity> entities) {
        DbContext db = this.context.getDbContext();
        int i = 0;
        try (Connection conn = this.ds.get();){
            this.establishSessionVariables(conn);
            try (Statement stmt = conn.createStatement();){
                Iterator iter = entities.map(e -> JDBCClient.deleteStatement(db, e)).iterator();
                while (iter.hasNext()) {
                    stmt.addBatch((String)iter.next());
                    if (++i % this.maxBatchSize != 0) continue;
                    stmt.executeBatch();
                }
                stmt.executeBatch();
            }
        }
        catch (SQLException e2) {
            throw new CdsDataStoreException("Failed to delete all entities", (Throwable)e2);
        }
    }

    private static String deleteStatement(DbContext db, CdsEntity entity) {
        String tableName = db.getSqlMapping((CdsStructuredType)entity).tableName();
        return db.getStatementResolver().deleteAll(tableName);
    }

    private class ColumnHandler {
        final String displayName;
        final boolean hidden;
        final boolean structuringAlias;
        final ValueBinder.Getter<Object> valueExtractor;

        ColumnHandler(String displayName, ValueBinder.Getter<Object> valueExtractor) {
            this.displayName = displayName;
            this.hidden = displayName.endsWith("?");
            this.structuringAlias = displayName.contains(".");
            this.valueExtractor = valueExtractor;
        }
    }

    private class ContextVars {
        private final SessionContext session;
        private final boolean enforce;
        Map<String, Object> contextVariables = new HashMap<String, Object>();

        public ContextVars(SessionContext session, boolean enforce) {
            this.session = session;
            this.enforce = enforce;
        }

        private void putIfRequired(String key, Function<SessionContext, Object> valueSupplier) {
            Object value = valueSupplier.apply(this.session);
            if (this.enforce || !Objects.equals(JDBCClient.this.oldSessionVars.getOrDefault(key, INITIAL), value)) {
                this.contextVariables.put(key, value);
            }
        }

        private boolean isEmpty() {
            return this.contextVariables.isEmpty();
        }

        private Map<String, Object> get() {
            return this.contextVariables;
        }
    }
}

